// Generated by rstantools.  Do not edit by hand.

/*
    mvgamHMC is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    mvgamHMC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with mvgamHMC.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_glmm_continuous_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_glmm_continuous");
    reader.add_event(258, 256, "end", "model_glmm_continuous");
    return reader;
}
#include <stan_meta_header.hpp>
class model_glmm_continuous
  : public stan::model::model_base_crtp<model_glmm_continuous> {
private:
        int N;
        int p;
        int q;
        int r;
        int nk;
        std::vector<int> zvars;
        vector_d y;
        matrix_d X;
        matrix_d Z;
        int max_col;
        int randint;
        int randeff;
        int qr;
        int qrsplit;
        int famnum;
        int linknum;
        vector_d offset;
        std::vector<int> lambdanum;
        int lambda_max_params;
        matrix_d lambda_param;
        std::vector<int> epsnum;
        int eps_max_params;
        matrix_d eps_param;
        std::vector<int> betanum;
        int beta_max_params;
        matrix_d beta_param;
        matrix_d Q_x;
        matrix_d R_x;
        matrix_d R_x_inverse;
        matrix_d Q_z;
        matrix_d R_z;
        matrix_d R_z_inverse;
        std::vector<matrix_d> qz;
        std::vector<matrix_d> rz;
        std::vector<matrix_d> rzinv;
public:
    model_glmm_continuous(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_glmm_continuous(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_glmm_continuous_namespace::model_glmm_continuous";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "p", "int", context__.to_vec());
            p = int(0);
            vals_i__ = context__.vals_i("p");
            pos__ = 0;
            p = vals_i__[pos__++];
            check_greater_or_equal(function__, "p", p, 0);
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "q", "int", context__.to_vec());
            q = int(0);
            vals_i__ = context__.vals_i("q");
            pos__ = 0;
            q = vals_i__[pos__++];
            check_greater_or_equal(function__, "q", q, 0);
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "r", "int", context__.to_vec());
            r = int(0);
            vals_i__ = context__.vals_i("r");
            pos__ = 0;
            r = vals_i__[pos__++];
            check_greater_or_equal(function__, "r", r, 0);
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "nk", "int", context__.to_vec());
            nk = int(0);
            vals_i__ = context__.vals_i("nk");
            pos__ = 0;
            nk = vals_i__[pos__++];
            check_greater_or_equal(function__, "nk", nk, 0);
            current_statement_begin__ = 14;
            validate_non_negative_index("zvars", "(logical_gt(nk, 0) ? (q + 1) : 0 )", (logical_gt(nk, 0) ? (q + 1) : 0 ));
            context__.validate_dims("data initialization", "zvars", "int", context__.to_vec((logical_gt(nk, 0) ? (q + 1) : 0 )));
            zvars = std::vector<int>((logical_gt(nk, 0) ? (q + 1) : 0 ), int(0));
            vals_i__ = context__.vals_i("zvars");
            pos__ = 0;
            size_t zvars_k_0_max__ = (logical_gt(nk, 0) ? (q + 1) : 0 );
            for (size_t k_0__ = 0; k_0__ < zvars_k_0_max__; ++k_0__) {
                zvars[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 16;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 18;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "p", p);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,p));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, p);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = p;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("Z", "(logical_gt(nk, 0) ? N : 0 )", (logical_gt(nk, 0) ? N : 0 ));
            validate_non_negative_index("Z", "(logical_gt(nk, 0) ? nk : 0 )", (logical_gt(nk, 0) ? nk : 0 ));
            context__.validate_dims("data initialization", "Z", "matrix_d", context__.to_vec((logical_gt(nk, 0) ? N : 0 ),(logical_gt(nk, 0) ? nk : 0 )));
            Z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_gt(nk, 0) ? N : 0 ), (logical_gt(nk, 0) ? nk : 0 ));
            vals_r__ = context__.vals_r("Z");
            pos__ = 0;
            size_t Z_j_2_max__ = (logical_gt(nk, 0) ? nk : 0 );
            size_t Z_j_1_max__ = (logical_gt(nk, 0) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                    Z(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 22;
            context__.validate_dims("data initialization", "max_col", "int", context__.to_vec());
            max_col = int(0);
            vals_i__ = context__.vals_i("max_col");
            pos__ = 0;
            max_col = vals_i__[pos__++];
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "randint", "int", context__.to_vec());
            randint = int(0);
            vals_i__ = context__.vals_i("randint");
            pos__ = 0;
            randint = vals_i__[pos__++];
            check_greater_or_equal(function__, "randint", randint, 0);
            check_less_or_equal(function__, "randint", randint, 1);
            current_statement_begin__ = 26;
            context__.validate_dims("data initialization", "randeff", "int", context__.to_vec());
            randeff = int(0);
            vals_i__ = context__.vals_i("randeff");
            pos__ = 0;
            randeff = vals_i__[pos__++];
            check_greater_or_equal(function__, "randeff", randeff, 0);
            check_less_or_equal(function__, "randeff", randeff, 1);
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "qr", "int", context__.to_vec());
            qr = int(0);
            vals_i__ = context__.vals_i("qr");
            pos__ = 0;
            qr = vals_i__[pos__++];
            check_greater_or_equal(function__, "qr", qr, 0);
            check_less_or_equal(function__, "qr", qr, 1);
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "qrsplit", "int", context__.to_vec());
            qrsplit = int(0);
            vals_i__ = context__.vals_i("qrsplit");
            pos__ = 0;
            qrsplit = vals_i__[pos__++];
            check_greater_or_equal(function__, "qrsplit", qrsplit, 0);
            check_less_or_equal(function__, "qrsplit", qrsplit, 1);
            current_statement_begin__ = 33;
            context__.validate_dims("data initialization", "famnum", "int", context__.to_vec());
            famnum = int(0);
            vals_i__ = context__.vals_i("famnum");
            pos__ = 0;
            famnum = vals_i__[pos__++];
            check_greater_or_equal(function__, "famnum", famnum, 1);
            check_less_or_equal(function__, "famnum", famnum, 3);
            current_statement_begin__ = 35;
            context__.validate_dims("data initialization", "linknum", "int", context__.to_vec());
            linknum = int(0);
            vals_i__ = context__.vals_i("linknum");
            pos__ = 0;
            linknum = vals_i__[pos__++];
            current_statement_begin__ = 37;
            validate_non_negative_index("offset", "N", N);
            context__.validate_dims("data initialization", "offset", "vector_d", context__.to_vec(N));
            offset = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("offset");
            pos__ = 0;
            size_t offset_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < offset_j_1_max__; ++j_1__) {
                offset(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 44;
            validate_non_negative_index("lambdanum", "(logical_gt(nk, 0) ? (q + 1) : 0 )", (logical_gt(nk, 0) ? (q + 1) : 0 ));
            context__.validate_dims("data initialization", "lambdanum", "int", context__.to_vec((logical_gt(nk, 0) ? (q + 1) : 0 )));
            lambdanum = std::vector<int>((logical_gt(nk, 0) ? (q + 1) : 0 ), int(0));
            vals_i__ = context__.vals_i("lambdanum");
            pos__ = 0;
            size_t lambdanum_k_0_max__ = (logical_gt(nk, 0) ? (q + 1) : 0 );
            for (size_t k_0__ = 0; k_0__ < lambdanum_k_0_max__; ++k_0__) {
                lambdanum[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "lambda_max_params", "int", context__.to_vec());
            lambda_max_params = int(0);
            vals_i__ = context__.vals_i("lambda_max_params");
            pos__ = 0;
            lambda_max_params = vals_i__[pos__++];
            current_statement_begin__ = 46;
            validate_non_negative_index("lambda_param", "(logical_gt(nk, 0) ? q : 0 )", (logical_gt(nk, 0) ? q : 0 ));
            validate_non_negative_index("lambda_param", "(logical_gt(nk, 0) ? lambda_max_params : 0 )", (logical_gt(nk, 0) ? lambda_max_params : 0 ));
            context__.validate_dims("data initialization", "lambda_param", "matrix_d", context__.to_vec((logical_gt(nk, 0) ? q : 0 ),(logical_gt(nk, 0) ? lambda_max_params : 0 )));
            lambda_param = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_gt(nk, 0) ? q : 0 ), (logical_gt(nk, 0) ? lambda_max_params : 0 ));
            vals_r__ = context__.vals_r("lambda_param");
            pos__ = 0;
            size_t lambda_param_j_2_max__ = (logical_gt(nk, 0) ? lambda_max_params : 0 );
            size_t lambda_param_j_1_max__ = (logical_gt(nk, 0) ? q : 0 );
            for (size_t j_2__ = 0; j_2__ < lambda_param_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < lambda_param_j_1_max__; ++j_1__) {
                    lambda_param(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 49;
            validate_non_negative_index("epsnum", "(r + 1)", (r + 1));
            context__.validate_dims("data initialization", "epsnum", "int", context__.to_vec((r + 1)));
            epsnum = std::vector<int>((r + 1), int(0));
            vals_i__ = context__.vals_i("epsnum");
            pos__ = 0;
            size_t epsnum_k_0_max__ = (r + 1);
            for (size_t k_0__ = 0; k_0__ < epsnum_k_0_max__; ++k_0__) {
                epsnum[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 50;
            context__.validate_dims("data initialization", "eps_max_params", "int", context__.to_vec());
            eps_max_params = int(0);
            vals_i__ = context__.vals_i("eps_max_params");
            pos__ = 0;
            eps_max_params = vals_i__[pos__++];
            current_statement_begin__ = 51;
            validate_non_negative_index("eps_param", "r", r);
            validate_non_negative_index("eps_param", "eps_max_params", eps_max_params);
            context__.validate_dims("data initialization", "eps_param", "matrix_d", context__.to_vec(r,eps_max_params));
            eps_param = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(r, eps_max_params);
            vals_r__ = context__.vals_r("eps_param");
            pos__ = 0;
            size_t eps_param_j_2_max__ = eps_max_params;
            size_t eps_param_j_1_max__ = r;
            for (size_t j_2__ = 0; j_2__ < eps_param_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eps_param_j_1_max__; ++j_1__) {
                    eps_param(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 54;
            validate_non_negative_index("betanum", "(p + 1)", (p + 1));
            context__.validate_dims("data initialization", "betanum", "int", context__.to_vec((p + 1)));
            betanum = std::vector<int>((p + 1), int(0));
            vals_i__ = context__.vals_i("betanum");
            pos__ = 0;
            size_t betanum_k_0_max__ = (p + 1);
            for (size_t k_0__ = 0; k_0__ < betanum_k_0_max__; ++k_0__) {
                betanum[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 55;
            context__.validate_dims("data initialization", "beta_max_params", "int", context__.to_vec());
            beta_max_params = int(0);
            vals_i__ = context__.vals_i("beta_max_params");
            pos__ = 0;
            beta_max_params = vals_i__[pos__++];
            current_statement_begin__ = 56;
            validate_non_negative_index("beta_param", "p", p);
            validate_non_negative_index("beta_param", "beta_max_params", beta_max_params);
            context__.validate_dims("data initialization", "beta_param", "matrix_d", context__.to_vec(p,beta_max_params));
            beta_param = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(p, beta_max_params);
            vals_r__ = context__.vals_r("beta_param");
            pos__ = 0;
            size_t beta_param_j_2_max__ = beta_max_params;
            size_t beta_param_j_1_max__ = p;
            for (size_t j_2__ = 0; j_2__ < beta_param_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_param_j_1_max__; ++j_1__) {
                    beta_param(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            // initialize transformed data variables
            current_statement_begin__ = 61;
            validate_non_negative_index("Q_x", "N", N);
            validate_non_negative_index("Q_x", "p", p);
            Q_x = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, p);
            stan::math::fill(Q_x, DUMMY_VAR__);
            current_statement_begin__ = 62;
            validate_non_negative_index("R_x", "p", p);
            validate_non_negative_index("R_x", "p", p);
            R_x = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(p, p);
            stan::math::fill(R_x, DUMMY_VAR__);
            current_statement_begin__ = 63;
            validate_non_negative_index("R_x_inverse", "p", p);
            validate_non_negative_index("R_x_inverse", "p", p);
            R_x_inverse = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(p, p);
            stan::math::fill(R_x_inverse, DUMMY_VAR__);
            current_statement_begin__ = 66;
            validate_non_negative_index("Q_z", "N", N);
            validate_non_negative_index("Q_z", "nk", nk);
            Q_z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, nk);
            stan::math::fill(Q_z, DUMMY_VAR__);
            current_statement_begin__ = 67;
            validate_non_negative_index("R_z", "nk", nk);
            validate_non_negative_index("R_z", "nk", nk);
            R_z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nk, nk);
            stan::math::fill(R_z, DUMMY_VAR__);
            current_statement_begin__ = 68;
            validate_non_negative_index("R_z_inverse", "nk", nk);
            validate_non_negative_index("R_z_inverse", "nk", nk);
            R_z_inverse = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nk, nk);
            stan::math::fill(R_z_inverse, DUMMY_VAR__);
            current_statement_begin__ = 71;
            validate_non_negative_index("qz", "N", N);
            validate_non_negative_index("qz", "max_col", max_col);
            validate_non_negative_index("qz", "q", q);
            qz = std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> >(q, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, max_col));
            stan::math::fill(qz, DUMMY_VAR__);
            current_statement_begin__ = 72;
            validate_non_negative_index("rz", "max_col", max_col);
            validate_non_negative_index("rz", "max_col", max_col);
            validate_non_negative_index("rz", "q", q);
            rz = std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> >(q, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(max_col, max_col));
            stan::math::fill(rz, DUMMY_VAR__);
            current_statement_begin__ = 73;
            validate_non_negative_index("rzinv", "max_col", max_col);
            validate_non_negative_index("rzinv", "max_col", max_col);
            validate_non_negative_index("rzinv", "q", q);
            rzinv = std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> >(q, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(max_col, max_col));
            stan::math::fill(rzinv, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 76;
            stan::math::assign(Q_x, multiply(stan::model::rvalue(qr_Q(X), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(1, p), stan::model::nil_index_list())), "qr_Q(X)"), stan::math::sqrt((N - 1))));
            current_statement_begin__ = 77;
            stan::math::assign(R_x, divide(stan::model::rvalue(qr_R(X), stan::model::cons_list(stan::model::index_min_max(1, p), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "qr_R(X)"), stan::math::sqrt((N - 1))));
            current_statement_begin__ = 78;
            stan::math::assign(R_x_inverse, inverse(R_x));
            current_statement_begin__ = 81;
            if (as_bool((primitive_value(logical_eq(randeff, 1)) || primitive_value(logical_eq(randint, 1))))) {
                current_statement_begin__ = 82;
                stan::math::assign(Q_z, multiply(stan::model::rvalue(qr_Q(Z), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(1, nk), stan::model::nil_index_list())), "qr_Q(Z)"), stan::math::sqrt((N - 1))));
                current_statement_begin__ = 83;
                stan::math::assign(R_z, divide(stan::model::rvalue(qr_R(Z), stan::model::cons_list(stan::model::index_min_max(1, nk), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "qr_R(Z)"), stan::math::sqrt((N - 1))));
                current_statement_begin__ = 84;
                stan::math::assign(R_z_inverse, inverse(R_z));
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 91;
            validate_non_negative_index("theta_b", "p", p);
            num_params_r__ += p;
            current_statement_begin__ = 92;
            validate_non_negative_index("tau", "nk", nk);
            num_params_r__ += nk;
            current_statement_begin__ = 93;
            validate_non_negative_index("lambda", "q", q);
            num_params_r__ += q;
            current_statement_begin__ = 94;
            validate_non_negative_index("eps", "r", r);
            num_params_r__ += r;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_glmm_continuous() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 91;
        if (!(context__.contains_r("theta_b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta_b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta_b");
        pos__ = 0U;
        validate_non_negative_index("theta_b", "p", p);
        context__.validate_dims("parameter initialization", "theta_b", "vector_d", context__.to_vec(p));
        Eigen::Matrix<double, Eigen::Dynamic, 1> theta_b(p);
        size_t theta_b_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < theta_b_j_1_max__; ++j_1__) {
            theta_b(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(theta_b);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta_b: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 92;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        validate_non_negative_index("tau", "nk", nk);
        context__.validate_dims("parameter initialization", "tau", "vector_d", context__.to_vec(nk));
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau(nk);
        size_t tau_j_1_max__ = nk;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            tau(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 93;
        if (!(context__.contains_r("lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0U;
        validate_non_negative_index("lambda", "q", q);
        context__.validate_dims("parameter initialization", "lambda", "vector_d", context__.to_vec(q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda(q);
        size_t lambda_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            lambda(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 94;
        if (!(context__.contains_r("eps")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eps missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eps");
        pos__ = 0U;
        validate_non_negative_index("eps", "r", r);
        context__.validate_dims("parameter initialization", "eps", "vector_d", context__.to_vec(r));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eps(r);
        size_t eps_j_1_max__ = r;
        for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
            eps(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, eps);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eps: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 91;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_b;
            (void) theta_b;  // dummy to suppress unused var warning
            if (jacobian__)
                theta_b = in__.vector_constrain(p, lp__);
            else
                theta_b = in__.vector_constrain(p);
            current_statement_begin__ = 92;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.vector_constrain(nk, lp__);
            else
                tau = in__.vector_constrain(nk);
            current_statement_begin__ = 93;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda;
            (void) lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda = in__.vector_lb_constrain(0, q, lp__);
            else
                lambda = in__.vector_lb_constrain(0, q);
            current_statement_begin__ = 94;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eps;
            (void) eps;  // dummy to suppress unused var warning
            if (jacobian__)
                eps = in__.vector_lb_constrain(0, r, lp__);
            else
                eps = in__.vector_lb_constrain(0, r);
            // transformed parameters
            current_statement_begin__ = 98;
            validate_non_negative_index("theta_u", "nk", nk);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_u(nk);
            stan::math::initialize(theta_u, DUMMY_VAR__);
            stan::math::fill(theta_u, DUMMY_VAR__);
            current_statement_begin__ = 99;
            validate_non_negative_index("beta", "p", p);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta(p);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 100;
            validate_non_negative_index("u", "nk", nk);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> u(nk);
            stan::math::initialize(u, DUMMY_VAR__);
            stan::math::fill(u, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 102;
            if (as_bool((primitive_value(logical_eq(randeff, 1)) || primitive_value(logical_eq(randint, 1))))) {
                current_statement_begin__ = 103;
                for (int l4 = 1; l4 <= 1; ++l4) {
                    {
                    current_statement_begin__ = 104;
                    int i(0);
                    (void) i;  // dummy to suppress unused var warning
                    stan::math::fill(i, std::numeric_limits<int>::min());
                    stan::math::assign(i,1);
                    current_statement_begin__ = 105;
                    for (int j4 = 1; j4 <= q; ++j4) {
                        current_statement_begin__ = 106;
                        for (int k4 = 1; k4 <= get_base1(zvars, j4, "zvars", 1); ++k4) {
                            current_statement_begin__ = 107;
                            stan::model::assign(theta_u, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(tau, i, "tau", 1) * get_base1(lambda, j4, "lambda", 1)), 
                                        "assigning variable theta_u");
                            current_statement_begin__ = 108;
                            stan::math::assign(i, (i + 1));
                        }
                    }
                    }
                }
            }
            current_statement_begin__ = 115;
            if (as_bool(logical_eq(qr, 1))) {
                current_statement_begin__ = 116;
                stan::math::assign(beta, multiply(R_x_inverse, theta_b));
                current_statement_begin__ = 117;
                if (as_bool((primitive_value(logical_eq(randeff, 1)) || primitive_value(logical_eq(randint, 1))))) {
                    current_statement_begin__ = 118;
                    stan::math::assign(u, multiply(R_z_inverse, theta_u));
                }
            } else {
                current_statement_begin__ = 121;
                stan::math::assign(beta, theta_b);
                current_statement_begin__ = 122;
                if (as_bool((primitive_value(logical_eq(randeff, 1)) || primitive_value(logical_eq(randint, 1))))) {
                    current_statement_begin__ = 123;
                    stan::math::assign(u, theta_u);
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 98;
            size_t theta_u_j_1_max__ = nk;
            for (size_t j_1__ = 0; j_1__ < theta_u_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta_u(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta_u" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta_u: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 99;
            size_t beta_j_1_max__ = p;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 100;
            size_t u_j_1_max__ = nk;
            for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(u(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: u" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable u: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 131;
            if (as_bool((primitive_value(logical_eq(randint, 1)) || primitive_value(logical_eq(randeff, 1))))) {
                current_statement_begin__ = 132;
                for (int k3 = 1; k3 <= q; ++k3) {
                    current_statement_begin__ = 133;
                    if (as_bool(logical_eq(get_base1(lambdanum, k3, "lambdanum", 1), 1))) {
                        current_statement_begin__ = 134;
                        lp_accum__.add(normal_log<propto__>(get_base1(lambda, k3, "lambda", 1), get_base1(lambda_param, k3, 1, "lambda_param", 1), get_base1(lambda_param, k3, 2, "lambda_param", 1)));
                    } else if (as_bool(logical_eq(get_base1(lambdanum, k3, "lambdanum", 1), 2))) {
                        current_statement_begin__ = 136;
                        lp_accum__.add(student_t_log<propto__>(get_base1(lambda, k3, "lambda", 1), get_base1(lambda_param, k3, 1, "lambda_param", 1), get_base1(lambda_param, k3, 2, "lambda_param", 1), get_base1(lambda_param, k3, 3, "lambda_param", 1)));
                    }
                }
            }
            current_statement_begin__ = 142;
            if (as_bool(logical_eq(famnum, 1))) {
                current_statement_begin__ = 143;
                for (int k2 = 1; k2 <= r; ++k2) {
                    current_statement_begin__ = 144;
                    if (as_bool(logical_eq(get_base1(epsnum, k2, "epsnum", 1), 1))) {
                        current_statement_begin__ = 145;
                        lp_accum__.add(normal_log<propto__>(get_base1(eps, k2, "eps", 1), get_base1(eps_param, k2, 1, "eps_param", 1), get_base1(eps_param, k2, 2, "eps_param", 1)));
                    } else if (as_bool(logical_eq(get_base1(epsnum, k2, "epsnum", 1), 2))) {
                        current_statement_begin__ = 147;
                        lp_accum__.add(student_t_log<propto__>(get_base1(eps, k2, "eps", 1), get_base1(eps_param, k2, 1, "eps_param", 1), get_base1(eps_param, k2, 2, "eps_param", 1), get_base1(eps_param, k2, 3, "eps_param", 1)));
                    }
                }
                current_statement_begin__ = 152;
                for (int k1 = 1; k1 <= p; ++k1) {
                    current_statement_begin__ = 153;
                    if (as_bool(logical_eq(get_base1(betanum, k1, "betanum", 1), 1))) {
                        current_statement_begin__ = 154;
                        lp_accum__.add(normal_log<propto__>(get_base1(theta_b, k1, "theta_b", 1), get_base1(beta_param, k1, 1, "beta_param", 1), get_base1(beta_param, k1, 2, "beta_param", 1)));
                    } else if (as_bool(logical_eq(get_base1(betanum, k1, "betanum", 1), 2))) {
                        current_statement_begin__ = 156;
                        lp_accum__.add(student_t_log<propto__>(get_base1(theta_b, k1, "theta_b", 1), get_base1(beta_param, k1, 1, "beta_param", 1), get_base1(beta_param, k1, 2, "beta_param", 1), get_base1(beta_param, k1, 3, "beta_param", 1)));
                    }
                }
                current_statement_begin__ = 160;
                if (as_bool((primitive_value(logical_eq(randeff, 1)) || primitive_value(logical_eq(randint, 1))))) {
                    current_statement_begin__ = 161;
                    for (int k2 = 1; k2 <= nk; ++k2) {
                        current_statement_begin__ = 162;
                        lp_accum__.add(normal_log<propto__>(get_base1(tau, k2, "tau", 1), 0, 1));
                    }
                }
                current_statement_begin__ = 166;
                if (as_bool((primitive_value(logical_eq(randeff, 1)) || primitive_value(logical_eq(randint, 1))))) {
                    current_statement_begin__ = 167;
                    if (as_bool(logical_eq(linknum, 1))) {
                        current_statement_begin__ = 168;
                        if (as_bool(logical_eq(qr, 1))) {
                            current_statement_begin__ = 169;
                            lp_accum__.add(normal_log<propto__>(y, add(add(multiply(Q_x, theta_b), multiply(Q_z, theta_u)), offset), get_base1(eps, 1, "eps", 1)));
                        } else {
                            current_statement_begin__ = 172;
                            lp_accum__.add(normal_log<propto__>(y, add(add(multiply(X, theta_b), multiply(Z, theta_u)), offset), get_base1(eps, 1, "eps", 1)));
                        }
                    } else if (as_bool(logical_eq(linknum, 2))) {
                        current_statement_begin__ = 176;
                        if (as_bool(logical_eq(qr, 1))) {
                            current_statement_begin__ = 177;
                            lp_accum__.add(normal_log<propto__>(y, stan::math::exp(add(add(multiply(Q_x, theta_b), multiply(Q_z, theta_u)), offset)), get_base1(eps, 1, "eps", 1)));
                        } else {
                            current_statement_begin__ = 180;
                            lp_accum__.add(normal_log<propto__>(y, stan::math::exp(add(add(multiply(X, theta_b), multiply(Z, theta_u)), offset)), get_base1(eps, 1, "eps", 1)));
                        }
                    } else if (as_bool(logical_eq(linknum, 3))) {
                        current_statement_begin__ = 184;
                        if (as_bool(logical_eq(qr, 1))) {
                            current_statement_begin__ = 185;
                            lp_accum__.add(normal_log<propto__>(y, inv(add(add(multiply(Q_x, theta_b), multiply(Q_z, theta_u)), offset)), get_base1(eps, 1, "eps", 1)));
                        } else {
                            current_statement_begin__ = 187;
                            lp_accum__.add(normal_log<propto__>(y, inv(add(add(multiply(X, theta_b), multiply(Z, theta_u)), offset)), get_base1(eps, 1, "eps", 1)));
                        }
                    }
                } else {
                    current_statement_begin__ = 191;
                    if (as_bool(logical_eq(linknum, 1))) {
                        current_statement_begin__ = 192;
                        if (as_bool(logical_eq(qr, 1))) {
                            current_statement_begin__ = 193;
                            lp_accum__.add(normal_log<propto__>(y, add(multiply(Q_x, theta_b), offset), get_base1(eps, 1, "eps", 1)));
                        } else {
                            current_statement_begin__ = 196;
                            lp_accum__.add(normal_log<propto__>(y, add(multiply(X, theta_b), offset), get_base1(eps, 1, "eps", 1)));
                        }
                    } else if (as_bool(logical_eq(linknum, 2))) {
                        current_statement_begin__ = 200;
                        if (as_bool(logical_eq(qr, 1))) {
                            current_statement_begin__ = 201;
                            lp_accum__.add(normal_log<propto__>(y, stan::math::exp(add(multiply(Q_x, theta_b), offset)), get_base1(eps, 1, "eps", 1)));
                        } else {
                            current_statement_begin__ = 204;
                            lp_accum__.add(normal_log<propto__>(y, stan::math::exp(add(multiply(X, theta_b), offset)), get_base1(eps, 1, "eps", 1)));
                        }
                    } else if (as_bool(logical_eq(linknum, 3))) {
                        current_statement_begin__ = 208;
                        if (as_bool(logical_eq(qr, 1))) {
                            current_statement_begin__ = 209;
                            lp_accum__.add(normal_log<propto__>(y, inv(add(multiply(Q_x, theta_b), offset)), get_base1(eps, 1, "eps", 1)));
                        } else {
                            current_statement_begin__ = 211;
                            lp_accum__.add(normal_log<propto__>(y, inv(add(multiply(X, theta_b), offset)), get_base1(eps, 1, "eps", 1)));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("theta_b");
        names__.push_back("tau");
        names__.push_back("lambda");
        names__.push_back("eps");
        names__.push_back("theta_u");
        names__.push_back("beta");
        names__.push_back("u");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nk);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(r);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nk);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nk);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_glmm_continuous_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> theta_b = in__.vector_constrain(p);
        size_t theta_b_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < theta_b_j_1_max__; ++j_1__) {
            vars__.push_back(theta_b(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau = in__.vector_constrain(nk);
        size_t tau_j_1_max__ = nk;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            vars__.push_back(tau(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda = in__.vector_lb_constrain(0, q);
        size_t lambda_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            vars__.push_back(lambda(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> eps = in__.vector_lb_constrain(0, r);
        size_t eps_j_1_max__ = r;
        for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
            vars__.push_back(eps(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 98;
            validate_non_negative_index("theta_u", "nk", nk);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_u(nk);
            stan::math::initialize(theta_u, DUMMY_VAR__);
            stan::math::fill(theta_u, DUMMY_VAR__);
            current_statement_begin__ = 99;
            validate_non_negative_index("beta", "p", p);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta(p);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 100;
            validate_non_negative_index("u", "nk", nk);
            Eigen::Matrix<double, Eigen::Dynamic, 1> u(nk);
            stan::math::initialize(u, DUMMY_VAR__);
            stan::math::fill(u, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 102;
            if (as_bool((primitive_value(logical_eq(randeff, 1)) || primitive_value(logical_eq(randint, 1))))) {
                current_statement_begin__ = 103;
                for (int l4 = 1; l4 <= 1; ++l4) {
                    {
                    current_statement_begin__ = 104;
                    int i(0);
                    (void) i;  // dummy to suppress unused var warning
                    stan::math::fill(i, std::numeric_limits<int>::min());
                    stan::math::assign(i,1);
                    current_statement_begin__ = 105;
                    for (int j4 = 1; j4 <= q; ++j4) {
                        current_statement_begin__ = 106;
                        for (int k4 = 1; k4 <= get_base1(zvars, j4, "zvars", 1); ++k4) {
                            current_statement_begin__ = 107;
                            stan::model::assign(theta_u, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(tau, i, "tau", 1) * get_base1(lambda, j4, "lambda", 1)), 
                                        "assigning variable theta_u");
                            current_statement_begin__ = 108;
                            stan::math::assign(i, (i + 1));
                        }
                    }
                    }
                }
            }
            current_statement_begin__ = 115;
            if (as_bool(logical_eq(qr, 1))) {
                current_statement_begin__ = 116;
                stan::math::assign(beta, multiply(R_x_inverse, theta_b));
                current_statement_begin__ = 117;
                if (as_bool((primitive_value(logical_eq(randeff, 1)) || primitive_value(logical_eq(randint, 1))))) {
                    current_statement_begin__ = 118;
                    stan::math::assign(u, multiply(R_z_inverse, theta_u));
                }
            } else {
                current_statement_begin__ = 121;
                stan::math::assign(beta, theta_b);
                current_statement_begin__ = 122;
                if (as_bool((primitive_value(logical_eq(randeff, 1)) || primitive_value(logical_eq(randint, 1))))) {
                    current_statement_begin__ = 123;
                    stan::math::assign(u, theta_u);
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t theta_u_j_1_max__ = nk;
                for (size_t j_1__ = 0; j_1__ < theta_u_j_1_max__; ++j_1__) {
                    vars__.push_back(theta_u(j_1__));
                }
                size_t beta_j_1_max__ = p;
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    vars__.push_back(beta(j_1__));
                }
                size_t u_j_1_max__ = nk;
                for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
                    vars__.push_back(u(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 223;
            validate_non_negative_index("log_lik", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 226;
            if (as_bool((primitive_value(logical_eq(randint, 1)) || primitive_value(logical_eq(randeff, 1))))) {
                current_statement_begin__ = 227;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 228;
                    if (as_bool(logical_eq(linknum, 1))) {
                        current_statement_begin__ = 229;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                    normal_log(get_base1(y, n, "y", 1), (multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + multiply(stan::model::rvalue(Z, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "Z"), u)), eps), 
                                    "assigning variable log_lik");
                    } else if (as_bool(logical_eq(linknum, 2))) {
                        current_statement_begin__ = 233;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                    normal_log(stan::math::exp(get_base1(y, n, "y", 1)), (multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + multiply(stan::model::rvalue(Z, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "Z"), u)), eps), 
                                    "assigning variable log_lik");
                    } else if (as_bool(logical_eq(linknum, 3))) {
                        current_statement_begin__ = 237;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                    normal_log(inv(get_base1(y, n, "y", 1)), (multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + multiply(stan::model::rvalue(Z, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "Z"), u)), eps), 
                                    "assigning variable log_lik");
                    }
                }
            } else {
                current_statement_begin__ = 241;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 242;
                    if (as_bool(logical_eq(linknum, 1))) {
                        current_statement_begin__ = 243;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                    normal_log(get_base1(y, n, "y", 1), multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta), eps), 
                                    "assigning variable log_lik");
                    } else if (as_bool(logical_eq(linknum, 2))) {
                        current_statement_begin__ = 247;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                    normal_log(stan::math::exp(get_base1(y, n, "y", 1)), multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta), eps), 
                                    "assigning variable log_lik");
                    } else if (as_bool(logical_eq(linknum, 3))) {
                        current_statement_begin__ = 251;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                    normal_log(inv(get_base1(y, n, "y", 1)), multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta), eps), 
                                    "assigning variable log_lik");
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 223;
            size_t log_lik_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_glmm_continuous";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t theta_b_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < theta_b_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_b" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = nk;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eps_j_1_max__ = r;
        for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eps" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_u_j_1_max__ = nk;
            for (size_t j_1__ = 0; j_1__ < theta_u_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_u" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_j_1_max__ = p;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t u_j_1_max__ = nk;
            for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "u" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t theta_b_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < theta_b_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_b" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = nk;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eps_j_1_max__ = r;
        for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eps" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_u_j_1_max__ = nk;
            for (size_t j_1__ = 0; j_1__ < theta_u_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_u" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_j_1_max__ = p;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t u_j_1_max__ = nk;
            for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "u" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_glmm_continuous_namespace::model_glmm_continuous stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
