
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_psiip_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psiip");
    reader.add_event(112, 112, "end", "model_psiip");
    return reader;
}

class model_psiip : public prob_grad {
private:
    int nSampledCells;
    vector<int> N;
    vector<int> y;
    double q;
    double minP;
public:
    model_psiip(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psiip(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psiip_namespace::model_psiip";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
            nSampledCells = int(0);
            vals_i__ = context__.vals_i("nSampledCells");
            pos__ = 0;
            nSampledCells = vals_i__[pos__++];
            current_statement_begin__ = 3;
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            N = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            size_t N_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
                N[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            y = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "q", "double", context__.to_vec());
            q = double(0);
            vals_r__ = context__.vals_r("q");
            pos__ = 0;
            q = vals_r__[pos__++];
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
            minP = double(0);
            vals_r__ = context__.vals_r("minP");
            pos__ = 0;
            minP = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 2;
            check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
            current_statement_begin__ = 3;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
            }
            current_statement_begin__ = 4;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
            }
            current_statement_begin__ = 5;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 6;
            check_greater_or_equal(function__,"minP",minP,q);
            check_less_or_equal(function__,"minP",minP,1);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 14;
            validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 15;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_psiip() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psi_Sampled")))
            throw std::runtime_error("variable psi_Sampled missing");
        vals_r__ = context__.vals_r("psi_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psi_Sampled", "vector_d", context__.to_vec(nSampledCells));
        vector_d psi_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psi_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("p")))
            throw std::runtime_error("variable p missing");
        vals_r__ = context__.vals_r("p");
        pos__ = 0U;
        context__.validate_dims("initialization", "p", "double", context__.to_vec());
        double p(0);
        p = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(stan::math::fmax(minP,q),1,p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_Sampled;
            (void) psi_Sampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

            T__ p;
            (void) p;  // dummy to suppress unused var warning
            if (jacobian__)
                p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1,lp__);
            else
                p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1);


            // transformed parameters
            current_statement_begin__ = 20;
            T__ qRate;
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, DUMMY_VAR__);
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 21;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, DUMMY_VAR__);
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 23;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 25;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            if (stan::math::is_uninitialized(qRate)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: qRate";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 20;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 21;

            // model body

            current_statement_begin__ = 39;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 42;
            lp_accum__.add(beta_log(psi_Sampled,0.5,0.5));
            current_statement_begin__ = 45;
            lp_accum__.add(lLh_cell);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psi_Sampled");
        names__.push_back("p");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("psi");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psiip_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        double p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psi_Sampled[k_0__]);
            }
        vars__.push_back(p);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 20;
            double qRate(0.0);
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 21;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 23;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 25;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            current_statement_begin__ = 20;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 21;

            // write transformed parameters
        vars__.push_back(qRate);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 53;
            validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
            vector<int> sim_y(nSampledCells, 0);
            stan::math::fill(sim_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 54;
            validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
            vector<int> sim_true_y(nSampledCells, 0);
            stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 55;
            validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
            vector<int> sim_false_y(nSampledCells, 0);
            stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 57;
            double psi(0.0);
            (void) psi;  // dummy to suppress unused var warning

            stan::math::initialize(psi, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi,DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("cellpres_i", "nSampledCells", nSampledCells);
            vector<double> cellpres_i(nSampledCells, 0.0);
            stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(cellpres_i,DUMMY_VAR__);
            current_statement_begin__ = 59;
            validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
            vector<double> pCorr(nSampledCells, 0.0);
            stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pCorr,DUMMY_VAR__);
            current_statement_begin__ = 60;
            validate_non_negative_index("pp", "nSampledCells", nSampledCells);
            vector_d pp(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) pp;  // dummy to suppress unused var warning

            stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pp,DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
            vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) expRec;  // dummy to suppress unused var warning

            stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(expRec,DUMMY_VAR__);
            current_statement_begin__ = 62;
            double chi_sq(0.0);
            (void) chi_sq;  // dummy to suppress unused var warning

            stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(chi_sq,DUMMY_VAR__);
            current_statement_begin__ = 63;
            double npars(0.0);
            (void) npars;  // dummy to suppress unused var warning

            stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(npars,DUMMY_VAR__);
            current_statement_begin__ = 64;
            double lLh(0.0);
            (void) lLh;  // dummy to suppress unused var warning

            stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh,DUMMY_VAR__);
            current_statement_begin__ = 65;
            double AIC(0.0);
            (void) AIC;  // dummy to suppress unused var warning

            stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AIC,DUMMY_VAR__);
            current_statement_begin__ = 66;
            double AICc(0.0);
            (void) AICc;  // dummy to suppress unused var warning

            stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AICc,DUMMY_VAR__);
            current_statement_begin__ = 67;
            double bAIC(0.0);
            (void) bAIC;  // dummy to suppress unused var warning

            stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(bAIC,DUMMY_VAR__);


            current_statement_begin__ = 70;
            stan::math::assign(npars, (nSampledCells + 1));
            current_statement_begin__ = 73;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 74;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 76;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 77;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 78;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 81;
            stan::math::assign(expRec, add(multiply(elt_multiply(psi_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psi_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 82;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 84;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 86;
                stan::math::assign(get_base1_lhs(pp,ncell,"pp",1), exp(((log(get_base1(psi_Sampled,ncell,"psi_Sampled",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p)) - log_mix(get_base1(psi_Sampled,ncell,"psi_Sampled",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 92;
                if (as_bool(bernoulli_rng(get_base1(pp,ncell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 93;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 1);
                    current_statement_begin__ = 94;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), p);
                    current_statement_begin__ = 95;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),p, base_rng__));
                    current_statement_begin__ = 96;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 99;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 0);
                    current_statement_begin__ = 100;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 101;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 102;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 105;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 109;
            stan::math::assign(psi, (sum(cellpres_i) / nSampledCells));

            // validate generated quantities
            current_statement_begin__ = 53;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
            }
            current_statement_begin__ = 54;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
            }
            current_statement_begin__ = 55;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
            }
            current_statement_begin__ = 57;
            check_greater_or_equal(function__,"psi",psi,0);
            check_less_or_equal(function__,"psi",psi,1);
            current_statement_begin__ = 58;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
                check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
            }
            current_statement_begin__ = 59;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
                check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
            }
            current_statement_begin__ = 60;
            check_greater_or_equal(function__,"pp",pp,0);
            check_less_or_equal(function__,"pp",pp,1);
            current_statement_begin__ = 61;
            current_statement_begin__ = 62;
            current_statement_begin__ = 63;
            current_statement_begin__ = 64;
            current_statement_begin__ = 65;
            current_statement_begin__ = 66;
            current_statement_begin__ = 67;

            // write generated quantities
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
            }
        vars__.push_back(psi);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pp[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
            }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psiip";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_psiip_CAR_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psiip_CAR");
    reader.add_event(187, 187, "end", "model_psiip_CAR");
    return reader;
}

template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 20;
        validate_non_negative_index("phit_D", "n", n);
        Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_D(static_cast<Eigen::VectorXd::Index>(n));
        (void) phit_D;  // dummy to suppress unused var warning

        stan::math::initialize(phit_D, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phit_D,DUMMY_VAR__);
        current_statement_begin__ = 21;
        validate_non_negative_index("phit_W", "n", n);
        Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_W(static_cast<Eigen::VectorXd::Index>(n));
        (void) phit_W;  // dummy to suppress unused var warning

        stan::math::initialize(phit_W, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phit_W,DUMMY_VAR__);
        current_statement_begin__ = 22;
        validate_non_negative_index("ldet_terms", "n", n);
        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ldet_terms(static_cast<Eigen::VectorXd::Index>(n));
        (void) ldet_terms;  // dummy to suppress unused var warning

        stan::math::initialize(ldet_terms, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ldet_terms,DUMMY_VAR__);


        current_statement_begin__ = 24;
        stan::math::assign(phit_D, transpose(elt_multiply(phi,D_sparse)));
        current_statement_begin__ = 25;
        stan::math::assign(phit_W, rep_row_vector(0,n));
        current_statement_begin__ = 26;
        for (int i = 1; i <= W_n; ++i) {

            current_statement_begin__ = 27;
            stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phi",1)));
            current_statement_begin__ = 28;
            stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phi",1)));
        }
        current_statement_begin__ = 31;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 31;
            stan::math::assign(get_base1_lhs(ldet_terms,i,"ldet_terms",1), log1m((alpha * get_base1(lambda,i,"lambda",1))));
        }
        current_statement_begin__ = 32;
        return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (((n * log(tau)) + sum(ldet_terms)) - (tau * (multiply(phit_D,phi) - (alpha * multiply(phit_W,phi)))))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    return sparse_car_lpdf<false>(phi,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__);
}


struct sparse_car_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) const {
        return sparse_car_lpdf(phi, tau, alpha, W_sparse, D_sparse, lambda, n, W_n, pstream__);
    }
};

class model_psiip_CAR : public prob_grad {
private:
    int nSampledCells;
    vector<int> sampledId;
    int nNotSampled;
    vector<int> notSampledId;
    int n;
    int W_n;
    vector<vector<int> > W_sparse;
    vector_d D_sparse;
    vector_d lambda;
    vector<int> N;
    vector<int> y;
    double q;
    double minP;
public:
    model_psiip_CAR(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psiip_CAR(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psiip_CAR_namespace::model_psiip_CAR";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
            nSampledCells = int(0);
            vals_i__ = context__.vals_i("nSampledCells");
            pos__ = 0;
            nSampledCells = vals_i__[pos__++];
            current_statement_begin__ = 42;
            validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "sampledId", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
            sampledId = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("sampledId");
            pos__ = 0;
            size_t sampledId_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < sampledId_limit_0__; ++i_0__) {
                sampledId[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "nNotSampled", "int", context__.to_vec());
            nNotSampled = int(0);
            vals_i__ = context__.vals_i("nNotSampled");
            pos__ = 0;
            nNotSampled = vals_i__[pos__++];
            current_statement_begin__ = 44;
            validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
            context__.validate_dims("data initialization", "notSampledId", "int", context__.to_vec(nNotSampled));
            validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
            notSampledId = std::vector<int>(nNotSampled,int(0));
            vals_i__ = context__.vals_i("notSampledId");
            pos__ = 0;
            size_t notSampledId_limit_0__ = nNotSampled;
            for (size_t i_0__ = 0; i_0__ < notSampledId_limit_0__; ++i_0__) {
                notSampledId[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "W_n", "int", context__.to_vec());
            W_n = int(0);
            vals_i__ = context__.vals_i("W_n");
            pos__ = 0;
            W_n = vals_i__[pos__++];
            current_statement_begin__ = 47;
            validate_non_negative_index("W_sparse", "W_n", W_n);
            validate_non_negative_index("W_sparse", "2", 2);
            context__.validate_dims("data initialization", "W_sparse", "int", context__.to_vec(W_n,2));
            validate_non_negative_index("W_sparse", "W_n", W_n);
            validate_non_negative_index("W_sparse", "2", 2);
            W_sparse = std::vector<std::vector<int> >(W_n,std::vector<int>(2,int(0)));
            vals_i__ = context__.vals_i("W_sparse");
            pos__ = 0;
            size_t W_sparse_limit_1__ = 2;
            for (size_t i_1__ = 0; i_1__ < W_sparse_limit_1__; ++i_1__) {
                size_t W_sparse_limit_0__ = W_n;
                for (size_t i_0__ = 0; i_0__ < W_sparse_limit_0__; ++i_0__) {
                    W_sparse[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 48;
            validate_non_negative_index("D_sparse", "n", n);
            context__.validate_dims("data initialization", "D_sparse", "vector_d", context__.to_vec(n));
            validate_non_negative_index("D_sparse", "n", n);
            D_sparse = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("D_sparse");
            pos__ = 0;
            size_t D_sparse_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < D_sparse_i_vec_lim__; ++i_vec__) {
                D_sparse[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 49;
            validate_non_negative_index("lambda", "n", n);
            context__.validate_dims("data initialization", "lambda", "vector_d", context__.to_vec(n));
            validate_non_negative_index("lambda", "n", n);
            lambda = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("lambda");
            pos__ = 0;
            size_t lambda_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < lambda_i_vec_lim__; ++i_vec__) {
                lambda[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 50;
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            N = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            size_t N_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
                N[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 51;
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            y = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 52;
            context__.validate_dims("data initialization", "q", "double", context__.to_vec());
            q = double(0);
            vals_r__ = context__.vals_r("q");
            pos__ = 0;
            q = vals_r__[pos__++];
            current_statement_begin__ = 53;
            context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
            minP = double(0);
            vals_r__ = context__.vals_r("minP");
            pos__ = 0;
            minP = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 41;
            check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
            current_statement_begin__ = 42;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sampledId[k0__]",sampledId[k0__],1);
            }
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"nNotSampled",nNotSampled,0);
            current_statement_begin__ = 44;
            for (int k0__ = 0; k0__ < nNotSampled; ++k0__) {
                check_greater_or_equal(function__,"notSampledId[k0__]",notSampledId[k0__],1);
            }
            current_statement_begin__ = 45;
            check_greater_or_equal(function__,"n",n,1);
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"W_n",W_n,1);
            current_statement_begin__ = 47;
            for (int k0__ = 0; k0__ < W_n; ++k0__) {
                for (int k1__ = 0; k1__ < 2; ++k1__) {
                    check_greater_or_equal(function__,"W_sparse[k0__][k1__]",W_sparse[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"D_sparse",D_sparse,1);
            current_statement_begin__ = 49;
            current_statement_begin__ = 50;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
            }
            current_statement_begin__ = 51;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
            }
            current_statement_begin__ = 52;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 53;
            check_greater_or_equal(function__,"minP",minP,q);
            check_less_or_equal(function__,"minP",minP,1);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 62;
            validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 63;
            validate_non_negative_index("psi_NotSampled", "nNotSampled", nNotSampled);
            num_params_r__ += nNotSampled;
            current_statement_begin__ = 64;
            ++num_params_r__;
            current_statement_begin__ = 65;
            ++num_params_r__;
            current_statement_begin__ = 66;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_psiip_CAR() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psi_Sampled")))
            throw std::runtime_error("variable psi_Sampled missing");
        vals_r__ = context__.vals_r("psi_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psi_Sampled", "vector_d", context__.to_vec(nSampledCells));
        vector_d psi_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psi_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("psi_NotSampled")))
            throw std::runtime_error("variable psi_NotSampled missing");
        vals_r__ = context__.vals_r("psi_NotSampled");
        pos__ = 0U;
        validate_non_negative_index("psi_NotSampled", "nNotSampled", nNotSampled);
        context__.validate_dims("initialization", "psi_NotSampled", "vector_d", context__.to_vec(nNotSampled));
        vector_d psi_NotSampled(static_cast<Eigen::VectorXd::Index>(nNotSampled));
        for (int j1__ = 0U; j1__ < nNotSampled; ++j1__)
            psi_NotSampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_NotSampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_NotSampled: ") + e.what());
        }

        if (!(context__.contains_r("p")))
            throw std::runtime_error("variable p missing");
        vals_r__ = context__.vals_r("p");
        pos__ = 0U;
        context__.validate_dims("initialization", "p", "double", context__.to_vec());
        double p(0);
        p = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(stan::math::fmax(minP,q),1,p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "double", context__.to_vec());
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_Sampled;
            (void) psi_Sampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_NotSampled;
            (void) psi_NotSampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled,lp__);
            else
                psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);

            T__ p;
            (void) p;  // dummy to suppress unused var warning
            if (jacobian__)
                p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1,lp__);
            else
                p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1);

            T__ tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.scalar_lb_constrain(0,lp__);
            else
                tau = in__.scalar_lb_constrain(0);

            T__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_lub_constrain(0,1,lp__);
            else
                alpha = in__.scalar_lub_constrain(0,1);


            // transformed parameters
            current_statement_begin__ = 72;
            validate_non_negative_index("psi_i", "n", n);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_i(static_cast<Eigen::VectorXd::Index>(n));
            (void) psi_i;  // dummy to suppress unused var warning

            stan::math::initialize(psi_i, DUMMY_VAR__);
            stan::math::fill(psi_i,DUMMY_VAR__);
            current_statement_begin__ = 73;
            T__ qRate;
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, DUMMY_VAR__);
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 74;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, DUMMY_VAR__);
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 76;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psi_Sampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 77;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psi_NotSampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 78;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 80;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 82;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < n; ++i0__) {
                if (stan::math::is_uninitialized(psi_i(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: psi_i" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            if (stan::math::is_uninitialized(qRate)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: qRate";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 72;
            check_greater_or_equal(function__,"psi_i",psi_i,0);
            check_less_or_equal(function__,"psi_i",psi_i,1);
            current_statement_begin__ = 73;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 74;

            // model body

            current_statement_begin__ = 97;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 100;
            lp_accum__.add(beta_log(psi_i,0.5,0.5));
            current_statement_begin__ = 101;
            lp_accum__.add(gamma_log(tau,2,2));
            current_statement_begin__ = 104;
            lp_accum__.add(lLh_cell);
            current_statement_begin__ = 112;
            lp_accum__.add(sparse_car_lpdf(psi_i,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psi_Sampled");
        names__.push_back("psi_NotSampled");
        names__.push_back("p");
        names__.push_back("tau");
        names__.push_back("alpha");
        names__.push_back("psi_i");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("cell");
        names__.push_back("psi");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nNotSampled);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psiip_CAR_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);
        double p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1);
        double tau = in__.scalar_lb_constrain(0);
        double alpha = in__.scalar_lub_constrain(0,1);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psi_Sampled[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nNotSampled; ++k_0__) {
            vars__.push_back(psi_NotSampled[k_0__]);
            }
        vars__.push_back(p);
        vars__.push_back(tau);
        vars__.push_back(alpha);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 72;
            validate_non_negative_index("psi_i", "n", n);
            vector_d psi_i(static_cast<Eigen::VectorXd::Index>(n));
            (void) psi_i;  // dummy to suppress unused var warning

            stan::math::initialize(psi_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi_i,DUMMY_VAR__);
            current_statement_begin__ = 73;
            double qRate(0.0);
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 74;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 76;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psi_Sampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 77;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psi_NotSampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 78;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 80;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 82;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            current_statement_begin__ = 72;
            check_greater_or_equal(function__,"psi_i",psi_i,0);
            check_less_or_equal(function__,"psi_i",psi_i,1);
            current_statement_begin__ = 73;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 74;

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(psi_i[k_0__]);
            }
        vars__.push_back(qRate);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 120;
            validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
            vector<int> sim_y(nSampledCells, 0);
            stan::math::fill(sim_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 121;
            validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
            vector<int> sim_true_y(nSampledCells, 0);
            stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 122;
            validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
            vector<int> sim_false_y(nSampledCells, 0);
            stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 123;
            int cell(0);
            (void) cell;  // dummy to suppress unused var warning

            stan::math::fill(cell, std::numeric_limits<int>::min());
            current_statement_begin__ = 125;
            double psi(0.0);
            (void) psi;  // dummy to suppress unused var warning

            stan::math::initialize(psi, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi,DUMMY_VAR__);
            current_statement_begin__ = 126;
            validate_non_negative_index("cellpres_i", "n", n);
            vector<double> cellpres_i(n, 0.0);
            stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(cellpres_i,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
            vector<double> pCorr(nSampledCells, 0.0);
            stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pCorr,DUMMY_VAR__);
            current_statement_begin__ = 128;
            validate_non_negative_index("pp", "n", n);
            vector_d pp(static_cast<Eigen::VectorXd::Index>(n));
            (void) pp;  // dummy to suppress unused var warning

            stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pp,DUMMY_VAR__);
            current_statement_begin__ = 129;
            validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
            vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) expRec;  // dummy to suppress unused var warning

            stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(expRec,DUMMY_VAR__);
            current_statement_begin__ = 130;
            double chi_sq(0.0);
            (void) chi_sq;  // dummy to suppress unused var warning

            stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(chi_sq,DUMMY_VAR__);
            current_statement_begin__ = 131;
            double npars(0.0);
            (void) npars;  // dummy to suppress unused var warning

            stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(npars,DUMMY_VAR__);
            current_statement_begin__ = 132;
            double lLh(0.0);
            (void) lLh;  // dummy to suppress unused var warning

            stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh,DUMMY_VAR__);
            current_statement_begin__ = 133;
            double AIC(0.0);
            (void) AIC;  // dummy to suppress unused var warning

            stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AIC,DUMMY_VAR__);
            current_statement_begin__ = 134;
            double AICc(0.0);
            (void) AICc;  // dummy to suppress unused var warning

            stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AICc,DUMMY_VAR__);
            current_statement_begin__ = 135;
            double bAIC(0.0);
            (void) bAIC;  // dummy to suppress unused var warning

            stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(bAIC,DUMMY_VAR__);


            current_statement_begin__ = 137;
            stan::math::assign(npars, ((((nSampledCells + nNotSampled) + 1) + 1) + 1));
            current_statement_begin__ = 140;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 141;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 142;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 143;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 146;
            stan::math::assign(expRec, add(multiply(elt_multiply(psi_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psi_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 147;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 150;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 152;
                stan::math::assign(cell, get_base1(sampledId,ncell,"sampledId",1));
                current_statement_begin__ = 153;
                stan::math::assign(get_base1_lhs(pp,cell,"pp",1), exp(((log(get_base1(psi_i,cell,"psi_i",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p)) - log_mix(get_base1(psi_i,cell,"psi_i",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 159;
                if (as_bool(bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 160;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 1);
                    current_statement_begin__ = 161;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), p);
                    current_statement_begin__ = 162;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),p, base_rng__));
                    current_statement_begin__ = 163;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 166;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 0);
                    current_statement_begin__ = 167;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 168;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 169;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 172;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 176;
            stan::model::assign(pp, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        stan::model::rvalue(psi_i, stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), "psi_i"), 
                        "assigning variable pp");
            current_statement_begin__ = 178;
            for (int ncell = 1; ncell <= nNotSampled; ++ncell) {

                current_statement_begin__ = 179;
                stan::math::assign(cell, get_base1(notSampledId,ncell,"notSampledId",1));
                current_statement_begin__ = 180;
                stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__));
            }
            current_statement_begin__ = 184;
            stan::math::assign(psi, (sum(cellpres_i) / n));

            // validate generated quantities
            current_statement_begin__ = 120;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
            }
            current_statement_begin__ = 121;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
            }
            current_statement_begin__ = 122;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
            }
            current_statement_begin__ = 123;
            check_greater_or_equal(function__,"cell",cell,1);
            current_statement_begin__ = 125;
            check_greater_or_equal(function__,"psi",psi,0);
            check_less_or_equal(function__,"psi",psi,1);
            current_statement_begin__ = 126;
            for (int k0__ = 0; k0__ < n; ++k0__) {
                check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
                check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
            }
            current_statement_begin__ = 127;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
                check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
            }
            current_statement_begin__ = 128;
            check_greater_or_equal(function__,"pp",pp,0);
            check_less_or_equal(function__,"pp",pp,1);
            current_statement_begin__ = 129;
            current_statement_begin__ = 130;
            current_statement_begin__ = 131;
            current_statement_begin__ = 132;
            current_statement_begin__ = 133;
            current_statement_begin__ = 134;
            current_statement_begin__ = 135;

            // write generated quantities
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
            }
        vars__.push_back(cell);
        vars__.push_back(psi);
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(pp[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
            }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psiip_CAR";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_psiipi_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psiipi");
    reader.add_event(128, 128, "end", "model_psiipi");
    return reader;
}

class model_psiipi : public prob_grad {
private:
    int nSampledCells;
    vector<int> N;
    vector<int> y;
    double q;
    double minP;
public:
    model_psiipi(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psiipi(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psiipi_namespace::model_psiipi";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
            nSampledCells = int(0);
            vals_i__ = context__.vals_i("nSampledCells");
            pos__ = 0;
            nSampledCells = vals_i__[pos__++];
            current_statement_begin__ = 3;
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            N = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            size_t N_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
                N[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            y = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "q", "double", context__.to_vec());
            q = double(0);
            vals_r__ = context__.vals_r("q");
            pos__ = 0;
            q = vals_r__[pos__++];
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
            minP = double(0);
            vals_r__ = context__.vals_r("minP");
            pos__ = 0;
            minP = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 2;
            check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
            current_statement_begin__ = 3;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
            }
            current_statement_begin__ = 4;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
            }
            current_statement_begin__ = 5;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 6;
            check_greater_or_equal(function__,"minP",minP,q);
            check_less_or_equal(function__,"minP",minP,1);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 15;
            validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 16;
            validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 17;
            validate_non_negative_index("odds", "2", 2);
            num_params_r__ += 2;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_psiipi() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psi_Sampled")))
            throw std::runtime_error("variable psi_Sampled missing");
        vals_r__ = context__.vals_r("psi_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psi_Sampled", "vector_d", context__.to_vec(nSampledCells));
        vector_d psi_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psi_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("p_raw")))
            throw std::runtime_error("variable p_raw missing");
        vals_r__ = context__.vals_r("p_raw");
        pos__ = 0U;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "p_raw", "vector_d", context__.to_vec(nSampledCells));
        vector_d p_raw(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            p_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,p_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p_raw: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "2", 2);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(2));
        vector_d odds(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_Sampled;
            (void) psi_Sampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  p_raw;
            (void) p_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                p_raw = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                p_raw = in__.vector_lub_constrain(0,1,nSampledCells);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
            (void) odds;  // dummy to suppress unused var warning
            if (jacobian__)
                odds = in__.ordered_constrain(2,lp__);
            else
                odds = in__.ordered_constrain(2);


            // transformed parameters
            current_statement_begin__ = 23;
            T__ pRange;
            (void) pRange;  // dummy to suppress unused var warning

            stan::math::initialize(pRange, DUMMY_VAR__);
            stan::math::fill(pRange,DUMMY_VAR__);
            current_statement_begin__ = 24;
            validate_non_negative_index("p", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 25;
            T__ pmax;
            (void) pmax;  // dummy to suppress unused var warning

            stan::math::initialize(pmax, DUMMY_VAR__);
            stan::math::fill(pmax,DUMMY_VAR__);
            current_statement_begin__ = 26;
            T__ pmin;
            (void) pmin;  // dummy to suppress unused var warning

            stan::math::initialize(pmin, DUMMY_VAR__);
            stan::math::fill(pmin,DUMMY_VAR__);
            current_statement_begin__ = 27;
            T__ qRate;
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, DUMMY_VAR__);
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 28;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, DUMMY_VAR__);
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 30;
            stan::math::assign(pmin, ((inv_logit(get_base1(odds,1,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 31;
            stan::math::assign(pmax, ((inv_logit(get_base1(odds,2,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 34;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 35;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 37;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 40;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 42;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            if (stan::math::is_uninitialized(pRange)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pRange";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(p(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: p" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            if (stan::math::is_uninitialized(pmax)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmax";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(pmin)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmin";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(qRate)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: qRate";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 23;
            check_greater_or_equal(function__,"pRange",pRange,0);
            check_less_or_equal(function__,"pRange",pRange,1);
            current_statement_begin__ = 24;
            check_greater_or_equal(function__,"p",p,0);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 25;
            check_greater_or_equal(function__,"pmax",pmax,stan::math::fmax(minP,q));
            check_less_or_equal(function__,"pmax",pmax,1);
            current_statement_begin__ = 26;
            check_greater_or_equal(function__,"pmin",pmin,stan::math::fmax(minP,q));
            check_less_or_equal(function__,"pmin",pmin,1);
            current_statement_begin__ = 27;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 28;

            // model body

            current_statement_begin__ = 54;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 55;
            lp_accum__.add(normal_log(pRange,0,0.10000000000000001));
            current_statement_begin__ = 57;
            lp_accum__.add(normal_log(pmin,0.5,0.25));
            current_statement_begin__ = 58;
            lp_accum__.add(normal_log(p_raw,1,0.25));
            current_statement_begin__ = 59;
            lp_accum__.add(normal_log(pmax,0.5,0.25));
            current_statement_begin__ = 61;
            lp_accum__.add(beta_log(psi_Sampled,0.5,0.5));
            current_statement_begin__ = 63;
            lp_accum__.add(lLh_cell);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psi_Sampled");
        names__.push_back("p_raw");
        names__.push_back("odds");
        names__.push_back("pRange");
        names__.push_back("p");
        names__.push_back("pmax");
        names__.push_back("pmin");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("psi");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psiipi_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d p_raw = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d odds = in__.ordered_constrain(2);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psi_Sampled[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p_raw[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(odds[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 23;
            double pRange(0.0);
            (void) pRange;  // dummy to suppress unused var warning

            stan::math::initialize(pRange, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pRange,DUMMY_VAR__);
            current_statement_begin__ = 24;
            validate_non_negative_index("p", "nSampledCells", nSampledCells);
            vector_d p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 25;
            double pmax(0.0);
            (void) pmax;  // dummy to suppress unused var warning

            stan::math::initialize(pmax, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pmax,DUMMY_VAR__);
            current_statement_begin__ = 26;
            double pmin(0.0);
            (void) pmin;  // dummy to suppress unused var warning

            stan::math::initialize(pmin, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pmin,DUMMY_VAR__);
            current_statement_begin__ = 27;
            double qRate(0.0);
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 28;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 30;
            stan::math::assign(pmin, ((inv_logit(get_base1(odds,1,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 31;
            stan::math::assign(pmax, ((inv_logit(get_base1(odds,2,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 34;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 35;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 37;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 40;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 42;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            current_statement_begin__ = 23;
            check_greater_or_equal(function__,"pRange",pRange,0);
            check_less_or_equal(function__,"pRange",pRange,1);
            current_statement_begin__ = 24;
            check_greater_or_equal(function__,"p",p,0);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 25;
            check_greater_or_equal(function__,"pmax",pmax,stan::math::fmax(minP,q));
            check_less_or_equal(function__,"pmax",pmax,1);
            current_statement_begin__ = 26;
            check_greater_or_equal(function__,"pmin",pmin,stan::math::fmax(minP,q));
            check_less_or_equal(function__,"pmin",pmin,1);
            current_statement_begin__ = 27;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 28;

            // write transformed parameters
        vars__.push_back(pRange);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p[k_0__]);
            }
        vars__.push_back(pmax);
        vars__.push_back(pmin);
        vars__.push_back(qRate);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 72;
            validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
            vector<int> sim_y(nSampledCells, 0);
            stan::math::fill(sim_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 73;
            validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
            vector<int> sim_true_y(nSampledCells, 0);
            stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 74;
            validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
            vector<int> sim_false_y(nSampledCells, 0);
            stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 76;
            double psi(0.0);
            (void) psi;  // dummy to suppress unused var warning

            stan::math::initialize(psi, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi,DUMMY_VAR__);
            current_statement_begin__ = 77;
            validate_non_negative_index("cellpres_i", "nSampledCells", nSampledCells);
            vector<double> cellpres_i(nSampledCells, 0.0);
            stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(cellpres_i,DUMMY_VAR__);
            current_statement_begin__ = 78;
            validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
            vector<double> pCorr(nSampledCells, 0.0);
            stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pCorr,DUMMY_VAR__);
            current_statement_begin__ = 79;
            validate_non_negative_index("pp", "nSampledCells", nSampledCells);
            vector_d pp(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) pp;  // dummy to suppress unused var warning

            stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pp,DUMMY_VAR__);
            current_statement_begin__ = 80;
            validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
            vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) expRec;  // dummy to suppress unused var warning

            stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(expRec,DUMMY_VAR__);
            current_statement_begin__ = 81;
            double chi_sq(0.0);
            (void) chi_sq;  // dummy to suppress unused var warning

            stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(chi_sq,DUMMY_VAR__);
            current_statement_begin__ = 82;
            double npars(0.0);
            (void) npars;  // dummy to suppress unused var warning

            stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(npars,DUMMY_VAR__);
            current_statement_begin__ = 83;
            double lLh(0.0);
            (void) lLh;  // dummy to suppress unused var warning

            stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh,DUMMY_VAR__);
            current_statement_begin__ = 84;
            double AIC(0.0);
            (void) AIC;  // dummy to suppress unused var warning

            stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AIC,DUMMY_VAR__);
            current_statement_begin__ = 85;
            double AICc(0.0);
            (void) AICc;  // dummy to suppress unused var warning

            stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AICc,DUMMY_VAR__);
            current_statement_begin__ = 86;
            double bAIC(0.0);
            (void) bAIC;  // dummy to suppress unused var warning

            stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(bAIC,DUMMY_VAR__);


            current_statement_begin__ = 88;
            stan::math::assign(npars, ((nSampledCells + nSampledCells) + 2));
            current_statement_begin__ = 90;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 91;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 92;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 93;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 96;
            stan::math::assign(expRec, add(elt_multiply(elt_multiply(psi_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psi_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 97;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 100;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 102;
                stan::math::assign(get_base1_lhs(pp,ncell,"pp",1), exp(((log(get_base1(psi_Sampled,ncell,"psi_Sampled",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1))) - log_mix(get_base1(psi_Sampled,ncell,"psi_Sampled",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1)),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 108;
                if (as_bool(bernoulli_rng(get_base1(pp,ncell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 109;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 1);
                    current_statement_begin__ = 110;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), get_base1(p,ncell,"p",1));
                    current_statement_begin__ = 111;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1), base_rng__));
                    current_statement_begin__ = 112;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 115;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 0);
                    current_statement_begin__ = 116;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 117;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 118;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 121;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 125;
            stan::math::assign(psi, (sum(cellpres_i) / nSampledCells));

            // validate generated quantities
            current_statement_begin__ = 72;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
            }
            current_statement_begin__ = 73;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
            }
            current_statement_begin__ = 74;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
            }
            current_statement_begin__ = 76;
            check_greater_or_equal(function__,"psi",psi,0);
            check_less_or_equal(function__,"psi",psi,1);
            current_statement_begin__ = 77;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
                check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
            }
            current_statement_begin__ = 78;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
                check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
            }
            current_statement_begin__ = 79;
            check_greater_or_equal(function__,"pp",pp,0);
            check_less_or_equal(function__,"pp",pp,1);
            current_statement_begin__ = 80;
            current_statement_begin__ = 81;
            current_statement_begin__ = 82;
            current_statement_begin__ = 83;
            current_statement_begin__ = 84;
            current_statement_begin__ = 85;
            current_statement_begin__ = 86;

            // write generated quantities
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
            }
        vars__.push_back(psi);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pp[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
            }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psiipi";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_psiipi_CAR_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psiipi_CAR");
    reader.add_event(201, 201, "end", "model_psiipi_CAR");
    return reader;
}

template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 20;
        validate_non_negative_index("phit_D", "n", n);
        Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_D(static_cast<Eigen::VectorXd::Index>(n));
        (void) phit_D;  // dummy to suppress unused var warning

        stan::math::initialize(phit_D, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phit_D,DUMMY_VAR__);
        current_statement_begin__ = 21;
        validate_non_negative_index("phit_W", "n", n);
        Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_W(static_cast<Eigen::VectorXd::Index>(n));
        (void) phit_W;  // dummy to suppress unused var warning

        stan::math::initialize(phit_W, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phit_W,DUMMY_VAR__);
        current_statement_begin__ = 22;
        validate_non_negative_index("ldet_terms", "n", n);
        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ldet_terms(static_cast<Eigen::VectorXd::Index>(n));
        (void) ldet_terms;  // dummy to suppress unused var warning

        stan::math::initialize(ldet_terms, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ldet_terms,DUMMY_VAR__);


        current_statement_begin__ = 24;
        stan::math::assign(phit_D, transpose(elt_multiply(phi,D_sparse)));
        current_statement_begin__ = 25;
        stan::math::assign(phit_W, rep_row_vector(0,n));
        current_statement_begin__ = 26;
        for (int i = 1; i <= W_n; ++i) {

            current_statement_begin__ = 27;
            stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phi",1)));
            current_statement_begin__ = 28;
            stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phi",1)));
        }
        current_statement_begin__ = 31;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 31;
            stan::math::assign(get_base1_lhs(ldet_terms,i,"ldet_terms",1), log1m((alpha * get_base1(lambda,i,"lambda",1))));
        }
        current_statement_begin__ = 32;
        return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (((n * log(tau)) + sum(ldet_terms)) - (tau * (multiply(phit_D,phi) - (alpha * multiply(phit_W,phi)))))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    return sparse_car_lpdf<false>(phi,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__);
}


struct sparse_car_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) const {
        return sparse_car_lpdf(phi, tau, alpha, W_sparse, D_sparse, lambda, n, W_n, pstream__);
    }
};

class model_psiipi_CAR : public prob_grad {
private:
    int nSampledCells;
    vector<int> sampledId;
    int nNotSampled;
    vector<int> notSampledId;
    int n;
    int W_n;
    vector<vector<int> > W_sparse;
    vector_d D_sparse;
    vector_d lambda;
    vector<int> N;
    vector<int> y;
    double q;
    double minP;
public:
    model_psiipi_CAR(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psiipi_CAR(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psiipi_CAR_namespace::model_psiipi_CAR";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
            nSampledCells = int(0);
            vals_i__ = context__.vals_i("nSampledCells");
            pos__ = 0;
            nSampledCells = vals_i__[pos__++];
            current_statement_begin__ = 42;
            validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "sampledId", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
            sampledId = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("sampledId");
            pos__ = 0;
            size_t sampledId_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < sampledId_limit_0__; ++i_0__) {
                sampledId[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "nNotSampled", "int", context__.to_vec());
            nNotSampled = int(0);
            vals_i__ = context__.vals_i("nNotSampled");
            pos__ = 0;
            nNotSampled = vals_i__[pos__++];
            current_statement_begin__ = 44;
            validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
            context__.validate_dims("data initialization", "notSampledId", "int", context__.to_vec(nNotSampled));
            validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
            notSampledId = std::vector<int>(nNotSampled,int(0));
            vals_i__ = context__.vals_i("notSampledId");
            pos__ = 0;
            size_t notSampledId_limit_0__ = nNotSampled;
            for (size_t i_0__ = 0; i_0__ < notSampledId_limit_0__; ++i_0__) {
                notSampledId[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "W_n", "int", context__.to_vec());
            W_n = int(0);
            vals_i__ = context__.vals_i("W_n");
            pos__ = 0;
            W_n = vals_i__[pos__++];
            current_statement_begin__ = 47;
            validate_non_negative_index("W_sparse", "W_n", W_n);
            validate_non_negative_index("W_sparse", "2", 2);
            context__.validate_dims("data initialization", "W_sparse", "int", context__.to_vec(W_n,2));
            validate_non_negative_index("W_sparse", "W_n", W_n);
            validate_non_negative_index("W_sparse", "2", 2);
            W_sparse = std::vector<std::vector<int> >(W_n,std::vector<int>(2,int(0)));
            vals_i__ = context__.vals_i("W_sparse");
            pos__ = 0;
            size_t W_sparse_limit_1__ = 2;
            for (size_t i_1__ = 0; i_1__ < W_sparse_limit_1__; ++i_1__) {
                size_t W_sparse_limit_0__ = W_n;
                for (size_t i_0__ = 0; i_0__ < W_sparse_limit_0__; ++i_0__) {
                    W_sparse[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 48;
            validate_non_negative_index("D_sparse", "n", n);
            context__.validate_dims("data initialization", "D_sparse", "vector_d", context__.to_vec(n));
            validate_non_negative_index("D_sparse", "n", n);
            D_sparse = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("D_sparse");
            pos__ = 0;
            size_t D_sparse_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < D_sparse_i_vec_lim__; ++i_vec__) {
                D_sparse[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 49;
            validate_non_negative_index("lambda", "n", n);
            context__.validate_dims("data initialization", "lambda", "vector_d", context__.to_vec(n));
            validate_non_negative_index("lambda", "n", n);
            lambda = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("lambda");
            pos__ = 0;
            size_t lambda_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < lambda_i_vec_lim__; ++i_vec__) {
                lambda[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 50;
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            N = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            size_t N_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
                N[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 51;
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            y = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 52;
            context__.validate_dims("data initialization", "q", "double", context__.to_vec());
            q = double(0);
            vals_r__ = context__.vals_r("q");
            pos__ = 0;
            q = vals_r__[pos__++];
            current_statement_begin__ = 53;
            context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
            minP = double(0);
            vals_r__ = context__.vals_r("minP");
            pos__ = 0;
            minP = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 41;
            check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
            current_statement_begin__ = 42;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sampledId[k0__]",sampledId[k0__],1);
            }
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"nNotSampled",nNotSampled,0);
            current_statement_begin__ = 44;
            for (int k0__ = 0; k0__ < nNotSampled; ++k0__) {
                check_greater_or_equal(function__,"notSampledId[k0__]",notSampledId[k0__],1);
            }
            current_statement_begin__ = 45;
            check_greater_or_equal(function__,"n",n,1);
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"W_n",W_n,1);
            current_statement_begin__ = 47;
            for (int k0__ = 0; k0__ < W_n; ++k0__) {
                for (int k1__ = 0; k1__ < 2; ++k1__) {
                    check_greater_or_equal(function__,"W_sparse[k0__][k1__]",W_sparse[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"D_sparse",D_sparse,1);
            current_statement_begin__ = 49;
            current_statement_begin__ = 50;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
            }
            current_statement_begin__ = 51;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
            }
            current_statement_begin__ = 52;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 53;
            check_greater_or_equal(function__,"minP",minP,q);
            check_less_or_equal(function__,"minP",minP,1);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 62;
            validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 63;
            validate_non_negative_index("psi_NotSampled", "nNotSampled", nNotSampled);
            num_params_r__ += nNotSampled;
            current_statement_begin__ = 64;
            validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 65;
            ++num_params_r__;
            current_statement_begin__ = 66;
            ++num_params_r__;
            current_statement_begin__ = 67;
            validate_non_negative_index("odds", "2", 2);
            num_params_r__ += 2;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_psiipi_CAR() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psi_Sampled")))
            throw std::runtime_error("variable psi_Sampled missing");
        vals_r__ = context__.vals_r("psi_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psi_Sampled", "vector_d", context__.to_vec(nSampledCells));
        vector_d psi_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psi_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("psi_NotSampled")))
            throw std::runtime_error("variable psi_NotSampled missing");
        vals_r__ = context__.vals_r("psi_NotSampled");
        pos__ = 0U;
        validate_non_negative_index("psi_NotSampled", "nNotSampled", nNotSampled);
        context__.validate_dims("initialization", "psi_NotSampled", "vector_d", context__.to_vec(nNotSampled));
        vector_d psi_NotSampled(static_cast<Eigen::VectorXd::Index>(nNotSampled));
        for (int j1__ = 0U; j1__ < nNotSampled; ++j1__)
            psi_NotSampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_NotSampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_NotSampled: ") + e.what());
        }

        if (!(context__.contains_r("p_raw")))
            throw std::runtime_error("variable p_raw missing");
        vals_r__ = context__.vals_r("p_raw");
        pos__ = 0U;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "p_raw", "vector_d", context__.to_vec(nSampledCells));
        vector_d p_raw(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            p_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,p_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p_raw: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "double", context__.to_vec());
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "2", 2);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(2));
        vector_d odds(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_Sampled;
            (void) psi_Sampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_NotSampled;
            (void) psi_NotSampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled,lp__);
            else
                psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  p_raw;
            (void) p_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                p_raw = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                p_raw = in__.vector_lub_constrain(0,1,nSampledCells);

            T__ tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.scalar_lb_constrain(0,lp__);
            else
                tau = in__.scalar_lb_constrain(0);

            T__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_lub_constrain(0,1,lp__);
            else
                alpha = in__.scalar_lub_constrain(0,1);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
            (void) odds;  // dummy to suppress unused var warning
            if (jacobian__)
                odds = in__.ordered_constrain(2,lp__);
            else
                odds = in__.ordered_constrain(2);


            // transformed parameters
            current_statement_begin__ = 72;
            T__ qRate;
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, DUMMY_VAR__);
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 73;
            T__ pRange;
            (void) pRange;  // dummy to suppress unused var warning

            stan::math::initialize(pRange, DUMMY_VAR__);
            stan::math::fill(pRange,DUMMY_VAR__);
            current_statement_begin__ = 74;
            validate_non_negative_index("psi_i", "n", n);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_i(static_cast<Eigen::VectorXd::Index>(n));
            (void) psi_i;  // dummy to suppress unused var warning

            stan::math::initialize(psi_i, DUMMY_VAR__);
            stan::math::fill(psi_i,DUMMY_VAR__);
            current_statement_begin__ = 75;
            validate_non_negative_index("p", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 76;
            T__ pmax;
            (void) pmax;  // dummy to suppress unused var warning

            stan::math::initialize(pmax, DUMMY_VAR__);
            stan::math::fill(pmax,DUMMY_VAR__);
            current_statement_begin__ = 77;
            T__ pmin;
            (void) pmin;  // dummy to suppress unused var warning

            stan::math::initialize(pmin, DUMMY_VAR__);
            stan::math::fill(pmin,DUMMY_VAR__);
            current_statement_begin__ = 78;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, DUMMY_VAR__);
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 80;
            stan::math::assign(pmin, ((inv_logit(get_base1(odds,1,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 81;
            stan::math::assign(pmax, ((inv_logit(get_base1(odds,2,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 83;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psi_Sampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 84;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psi_NotSampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 85;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 86;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 89;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 91;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 93;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            if (stan::math::is_uninitialized(qRate)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: qRate";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(pRange)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pRange";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < n; ++i0__) {
                if (stan::math::is_uninitialized(psi_i(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: psi_i" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(p(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: p" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            if (stan::math::is_uninitialized(pmax)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmax";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(pmin)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmin";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 72;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 73;
            check_greater_or_equal(function__,"pRange",pRange,0);
            check_less_or_equal(function__,"pRange",pRange,1);
            current_statement_begin__ = 74;
            check_greater_or_equal(function__,"psi_i",psi_i,0);
            check_less_or_equal(function__,"psi_i",psi_i,1);
            current_statement_begin__ = 75;
            check_greater_or_equal(function__,"p",p,0);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 76;
            check_greater_or_equal(function__,"pmax",pmax,stan::math::fmax(minP,q));
            check_less_or_equal(function__,"pmax",pmax,1);
            current_statement_begin__ = 77;
            check_greater_or_equal(function__,"pmin",pmin,stan::math::fmax(minP,q));
            check_less_or_equal(function__,"pmin",pmin,1);
            current_statement_begin__ = 78;

            // model body

            current_statement_begin__ = 107;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 108;
            lp_accum__.add(normal_log(pRange,0,0.10000000000000001));
            current_statement_begin__ = 110;
            lp_accum__.add(normal_log(pmin,0.5,0.25));
            current_statement_begin__ = 111;
            lp_accum__.add(normal_log(p_raw,1,0.25));
            current_statement_begin__ = 112;
            lp_accum__.add(normal_log(pmax,0.5,0.25));
            current_statement_begin__ = 114;
            lp_accum__.add(beta_log(psi_i,0.5,0.5));
            current_statement_begin__ = 115;
            lp_accum__.add(gamma_log(tau,2,2));
            current_statement_begin__ = 119;
            lp_accum__.add(lLh_cell);
            current_statement_begin__ = 126;
            lp_accum__.add(sparse_car_lpdf(psi_i,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psi_Sampled");
        names__.push_back("psi_NotSampled");
        names__.push_back("p_raw");
        names__.push_back("tau");
        names__.push_back("alpha");
        names__.push_back("odds");
        names__.push_back("qRate");
        names__.push_back("pRange");
        names__.push_back("psi_i");
        names__.push_back("p");
        names__.push_back("pmax");
        names__.push_back("pmin");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("cell");
        names__.push_back("psi");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nNotSampled);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psiipi_CAR_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);
        vector_d p_raw = in__.vector_lub_constrain(0,1,nSampledCells);
        double tau = in__.scalar_lb_constrain(0);
        double alpha = in__.scalar_lub_constrain(0,1);
        vector_d odds = in__.ordered_constrain(2);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psi_Sampled[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nNotSampled; ++k_0__) {
            vars__.push_back(psi_NotSampled[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p_raw[k_0__]);
            }
        vars__.push_back(tau);
        vars__.push_back(alpha);
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(odds[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 72;
            double qRate(0.0);
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 73;
            double pRange(0.0);
            (void) pRange;  // dummy to suppress unused var warning

            stan::math::initialize(pRange, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pRange,DUMMY_VAR__);
            current_statement_begin__ = 74;
            validate_non_negative_index("psi_i", "n", n);
            vector_d psi_i(static_cast<Eigen::VectorXd::Index>(n));
            (void) psi_i;  // dummy to suppress unused var warning

            stan::math::initialize(psi_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi_i,DUMMY_VAR__);
            current_statement_begin__ = 75;
            validate_non_negative_index("p", "nSampledCells", nSampledCells);
            vector_d p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 76;
            double pmax(0.0);
            (void) pmax;  // dummy to suppress unused var warning

            stan::math::initialize(pmax, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pmax,DUMMY_VAR__);
            current_statement_begin__ = 77;
            double pmin(0.0);
            (void) pmin;  // dummy to suppress unused var warning

            stan::math::initialize(pmin, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pmin,DUMMY_VAR__);
            current_statement_begin__ = 78;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 80;
            stan::math::assign(pmin, ((inv_logit(get_base1(odds,1,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 81;
            stan::math::assign(pmax, ((inv_logit(get_base1(odds,2,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 83;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psi_Sampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 84;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psi_NotSampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 85;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 86;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 89;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 91;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 93;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            current_statement_begin__ = 72;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 73;
            check_greater_or_equal(function__,"pRange",pRange,0);
            check_less_or_equal(function__,"pRange",pRange,1);
            current_statement_begin__ = 74;
            check_greater_or_equal(function__,"psi_i",psi_i,0);
            check_less_or_equal(function__,"psi_i",psi_i,1);
            current_statement_begin__ = 75;
            check_greater_or_equal(function__,"p",p,0);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 76;
            check_greater_or_equal(function__,"pmax",pmax,stan::math::fmax(minP,q));
            check_less_or_equal(function__,"pmax",pmax,1);
            current_statement_begin__ = 77;
            check_greater_or_equal(function__,"pmin",pmin,stan::math::fmax(minP,q));
            check_less_or_equal(function__,"pmin",pmin,1);
            current_statement_begin__ = 78;

            // write transformed parameters
        vars__.push_back(qRate);
        vars__.push_back(pRange);
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(psi_i[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p[k_0__]);
            }
        vars__.push_back(pmax);
        vars__.push_back(pmin);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 134;
            validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
            vector<int> sim_y(nSampledCells, 0);
            stan::math::fill(sim_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 135;
            validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
            vector<int> sim_true_y(nSampledCells, 0);
            stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 136;
            validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
            vector<int> sim_false_y(nSampledCells, 0);
            stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 137;
            int cell(0);
            (void) cell;  // dummy to suppress unused var warning

            stan::math::fill(cell, std::numeric_limits<int>::min());
            current_statement_begin__ = 139;
            double psi(0.0);
            (void) psi;  // dummy to suppress unused var warning

            stan::math::initialize(psi, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi,DUMMY_VAR__);
            current_statement_begin__ = 140;
            validate_non_negative_index("cellpres_i", "n", n);
            vector<double> cellpres_i(n, 0.0);
            stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(cellpres_i,DUMMY_VAR__);
            current_statement_begin__ = 141;
            validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
            vector<double> pCorr(nSampledCells, 0.0);
            stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pCorr,DUMMY_VAR__);
            current_statement_begin__ = 142;
            validate_non_negative_index("pp", "n", n);
            vector_d pp(static_cast<Eigen::VectorXd::Index>(n));
            (void) pp;  // dummy to suppress unused var warning

            stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pp,DUMMY_VAR__);
            current_statement_begin__ = 143;
            validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
            vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) expRec;  // dummy to suppress unused var warning

            stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(expRec,DUMMY_VAR__);
            current_statement_begin__ = 144;
            double chi_sq(0.0);
            (void) chi_sq;  // dummy to suppress unused var warning

            stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(chi_sq,DUMMY_VAR__);
            current_statement_begin__ = 145;
            double npars(0.0);
            (void) npars;  // dummy to suppress unused var warning

            stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(npars,DUMMY_VAR__);
            current_statement_begin__ = 146;
            double lLh(0.0);
            (void) lLh;  // dummy to suppress unused var warning

            stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh,DUMMY_VAR__);
            current_statement_begin__ = 147;
            double AIC(0.0);
            (void) AIC;  // dummy to suppress unused var warning

            stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AIC,DUMMY_VAR__);
            current_statement_begin__ = 148;
            double AICc(0.0);
            (void) AICc;  // dummy to suppress unused var warning

            stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AICc,DUMMY_VAR__);
            current_statement_begin__ = 149;
            double bAIC(0.0);
            (void) bAIC;  // dummy to suppress unused var warning

            stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(bAIC,DUMMY_VAR__);


            current_statement_begin__ = 151;
            stan::math::assign(npars, (((((nSampledCells + nNotSampled) + nSampledCells) + 1) + 1) + 2));
            current_statement_begin__ = 154;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 155;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 156;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 157;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 160;
            stan::math::assign(expRec, add(elt_multiply(elt_multiply(psi_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psi_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 161;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 164;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 166;
                stan::math::assign(cell, get_base1(sampledId,ncell,"sampledId",1));
                current_statement_begin__ = 167;
                stan::math::assign(get_base1_lhs(pp,cell,"pp",1), exp(((log(get_base1(psi_i,cell,"psi_i",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1))) - log_mix(get_base1(psi_i,cell,"psi_i",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1)),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 173;
                if (as_bool(bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 174;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 1);
                    current_statement_begin__ = 175;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), get_base1(p,ncell,"p",1));
                    current_statement_begin__ = 176;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1), base_rng__));
                    current_statement_begin__ = 177;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 180;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 0);
                    current_statement_begin__ = 181;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 182;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 183;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 186;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 190;
            stan::model::assign(pp, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        stan::model::rvalue(psi_i, stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), "psi_i"), 
                        "assigning variable pp");
            current_statement_begin__ = 192;
            for (int ncell = 1; ncell <= nNotSampled; ++ncell) {

                current_statement_begin__ = 193;
                stan::math::assign(cell, get_base1(notSampledId,ncell,"notSampledId",1));
                current_statement_begin__ = 194;
                stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__));
            }
            current_statement_begin__ = 198;
            stan::math::assign(psi, (sum(cellpres_i) / n));

            // validate generated quantities
            current_statement_begin__ = 134;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
            }
            current_statement_begin__ = 135;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
            }
            current_statement_begin__ = 136;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
            }
            current_statement_begin__ = 137;
            check_greater_or_equal(function__,"cell",cell,1);
            current_statement_begin__ = 139;
            check_greater_or_equal(function__,"psi",psi,0);
            check_less_or_equal(function__,"psi",psi,1);
            current_statement_begin__ = 140;
            for (int k0__ = 0; k0__ < n; ++k0__) {
                check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
                check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
            }
            current_statement_begin__ = 141;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
                check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
            }
            current_statement_begin__ = 142;
            check_greater_or_equal(function__,"pp",pp,0);
            check_less_or_equal(function__,"pp",pp,1);
            current_statement_begin__ = 143;
            current_statement_begin__ = 144;
            current_statement_begin__ = 145;
            current_statement_begin__ = 146;
            current_statement_begin__ = 147;
            current_statement_begin__ = 148;
            current_statement_begin__ = 149;

            // write generated quantities
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
            }
        vars__.push_back(cell);
        vars__.push_back(psi);
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(pp[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
            }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psiipi_CAR";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_psiipiq_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psiipiq");
    reader.add_event(128, 128, "end", "model_psiipiq");
    return reader;
}

class model_psiipiq : public prob_grad {
private:
    int nSampledCells;
    vector<int> N;
    vector<int> y;
    double minP;
public:
    model_psiipiq(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psiipiq(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psiipiq_namespace::model_psiipiq";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
            nSampledCells = int(0);
            vals_i__ = context__.vals_i("nSampledCells");
            pos__ = 0;
            nSampledCells = vals_i__[pos__++];
            current_statement_begin__ = 3;
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            N = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            size_t N_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
                N[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            y = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
            minP = double(0);
            vals_r__ = context__.vals_r("minP");
            pos__ = 0;
            minP = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 2;
            check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
            current_statement_begin__ = 3;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
            }
            current_statement_begin__ = 4;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
            }
            current_statement_begin__ = 5;
            check_greater_or_equal(function__,"minP",minP,0);
            check_less_or_equal(function__,"minP",minP,1);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 13;
            validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 14;
            validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 15;
            validate_non_negative_index("odds", "3", 3);
            num_params_r__ += 3;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_psiipiq() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psi_Sampled")))
            throw std::runtime_error("variable psi_Sampled missing");
        vals_r__ = context__.vals_r("psi_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psi_Sampled", "vector_d", context__.to_vec(nSampledCells));
        vector_d psi_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psi_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("p_raw")))
            throw std::runtime_error("variable p_raw missing");
        vals_r__ = context__.vals_r("p_raw");
        pos__ = 0U;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "p_raw", "vector_d", context__.to_vec(nSampledCells));
        vector_d p_raw(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            p_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,p_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p_raw: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "3", 3);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(3));
        vector_d odds(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_Sampled;
            (void) psi_Sampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  p_raw;
            (void) p_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                p_raw = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                p_raw = in__.vector_lub_constrain(0,1,nSampledCells);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
            (void) odds;  // dummy to suppress unused var warning
            if (jacobian__)
                odds = in__.ordered_constrain(3,lp__);
            else
                odds = in__.ordered_constrain(3);


            // transformed parameters
            current_statement_begin__ = 22;
            T__ q;
            (void) q;  // dummy to suppress unused var warning

            stan::math::initialize(q, DUMMY_VAR__);
            stan::math::fill(q,DUMMY_VAR__);
            current_statement_begin__ = 23;
            T__ pmax;
            (void) pmax;  // dummy to suppress unused var warning

            stan::math::initialize(pmax, DUMMY_VAR__);
            stan::math::fill(pmax,DUMMY_VAR__);
            current_statement_begin__ = 24;
            T__ pmin;
            (void) pmin;  // dummy to suppress unused var warning

            stan::math::initialize(pmin, DUMMY_VAR__);
            stan::math::fill(pmin,DUMMY_VAR__);
            current_statement_begin__ = 25;
            T__ qRate;
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, DUMMY_VAR__);
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 26;
            T__ pRange;
            (void) pRange;  // dummy to suppress unused var warning

            stan::math::initialize(pRange, DUMMY_VAR__);
            stan::math::fill(pRange,DUMMY_VAR__);
            current_statement_begin__ = 27;
            validate_non_negative_index("p", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 28;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, DUMMY_VAR__);
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 30;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 31;
            stan::math::assign(pmin, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 32;
            stan::math::assign(pmax, inv_logit(get_base1(odds,3,"odds",1)));
            current_statement_begin__ = 34;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 35;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 36;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 38;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 40;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            if (stan::math::is_uninitialized(q)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: q";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(pmax)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmax";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(pmin)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmin";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(qRate)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: qRate";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(pRange)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pRange";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(p(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: p" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 22;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 23;
            check_greater_or_equal(function__,"pmax",pmax,minP);
            check_less_or_equal(function__,"pmax",pmax,1);
            current_statement_begin__ = 24;
            check_greater_or_equal(function__,"pmin",pmin,minP);
            check_less_or_equal(function__,"pmin",pmin,1);
            current_statement_begin__ = 25;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 26;
            check_greater_or_equal(function__,"pRange",pRange,0);
            check_less_or_equal(function__,"pRange",pRange,1);
            current_statement_begin__ = 27;
            check_greater_or_equal(function__,"p",p,0);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 28;

            // model body

            current_statement_begin__ = 53;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 54;
            lp_accum__.add(normal_log(pRange,0,0.10000000000000001));
            current_statement_begin__ = 56;
            lp_accum__.add(normal_log(pmin,0.5,0.25));
            current_statement_begin__ = 57;
            lp_accum__.add(normal_log(p_raw,1,0.25));
            current_statement_begin__ = 58;
            lp_accum__.add(normal_log(pmax,0.5,0.25));
            current_statement_begin__ = 60;
            lp_accum__.add(beta_log(psi_Sampled,0.5,0.5));
            current_statement_begin__ = 62;
            lp_accum__.add(lLh_cell);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psi_Sampled");
        names__.push_back("p_raw");
        names__.push_back("odds");
        names__.push_back("q");
        names__.push_back("pmax");
        names__.push_back("pmin");
        names__.push_back("qRate");
        names__.push_back("pRange");
        names__.push_back("p");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("psi");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psiipiq_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d p_raw = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d odds = in__.ordered_constrain(3);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psi_Sampled[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p_raw[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(odds[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 22;
            double q(0.0);
            (void) q;  // dummy to suppress unused var warning

            stan::math::initialize(q, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(q,DUMMY_VAR__);
            current_statement_begin__ = 23;
            double pmax(0.0);
            (void) pmax;  // dummy to suppress unused var warning

            stan::math::initialize(pmax, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pmax,DUMMY_VAR__);
            current_statement_begin__ = 24;
            double pmin(0.0);
            (void) pmin;  // dummy to suppress unused var warning

            stan::math::initialize(pmin, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pmin,DUMMY_VAR__);
            current_statement_begin__ = 25;
            double qRate(0.0);
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 26;
            double pRange(0.0);
            (void) pRange;  // dummy to suppress unused var warning

            stan::math::initialize(pRange, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pRange,DUMMY_VAR__);
            current_statement_begin__ = 27;
            validate_non_negative_index("p", "nSampledCells", nSampledCells);
            vector_d p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 28;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 30;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 31;
            stan::math::assign(pmin, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 32;
            stan::math::assign(pmax, inv_logit(get_base1(odds,3,"odds",1)));
            current_statement_begin__ = 34;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 35;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 36;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 38;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 40;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            current_statement_begin__ = 22;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 23;
            check_greater_or_equal(function__,"pmax",pmax,minP);
            check_less_or_equal(function__,"pmax",pmax,1);
            current_statement_begin__ = 24;
            check_greater_or_equal(function__,"pmin",pmin,minP);
            check_less_or_equal(function__,"pmin",pmin,1);
            current_statement_begin__ = 25;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 26;
            check_greater_or_equal(function__,"pRange",pRange,0);
            check_less_or_equal(function__,"pRange",pRange,1);
            current_statement_begin__ = 27;
            check_greater_or_equal(function__,"p",p,0);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 28;

            // write transformed parameters
        vars__.push_back(q);
        vars__.push_back(pmax);
        vars__.push_back(pmin);
        vars__.push_back(qRate);
        vars__.push_back(pRange);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 71;
            validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
            vector<int> sim_y(nSampledCells, 0);
            stan::math::fill(sim_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 72;
            validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
            vector<int> sim_true_y(nSampledCells, 0);
            stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 73;
            validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
            vector<int> sim_false_y(nSampledCells, 0);
            stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 75;
            double psi(0.0);
            (void) psi;  // dummy to suppress unused var warning

            stan::math::initialize(psi, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi,DUMMY_VAR__);
            current_statement_begin__ = 76;
            validate_non_negative_index("cellpres_i", "nSampledCells", nSampledCells);
            vector<double> cellpres_i(nSampledCells, 0.0);
            stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(cellpres_i,DUMMY_VAR__);
            current_statement_begin__ = 77;
            validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
            vector<double> pCorr(nSampledCells, 0.0);
            stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pCorr,DUMMY_VAR__);
            current_statement_begin__ = 78;
            validate_non_negative_index("pp", "nSampledCells", nSampledCells);
            vector_d pp(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) pp;  // dummy to suppress unused var warning

            stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pp,DUMMY_VAR__);
            current_statement_begin__ = 79;
            validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
            vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) expRec;  // dummy to suppress unused var warning

            stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(expRec,DUMMY_VAR__);
            current_statement_begin__ = 80;
            double chi_sq(0.0);
            (void) chi_sq;  // dummy to suppress unused var warning

            stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(chi_sq,DUMMY_VAR__);
            current_statement_begin__ = 81;
            double npars(0.0);
            (void) npars;  // dummy to suppress unused var warning

            stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(npars,DUMMY_VAR__);
            current_statement_begin__ = 82;
            double lLh(0.0);
            (void) lLh;  // dummy to suppress unused var warning

            stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh,DUMMY_VAR__);
            current_statement_begin__ = 83;
            double AIC(0.0);
            (void) AIC;  // dummy to suppress unused var warning

            stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AIC,DUMMY_VAR__);
            current_statement_begin__ = 84;
            double AICc(0.0);
            (void) AICc;  // dummy to suppress unused var warning

            stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AICc,DUMMY_VAR__);
            current_statement_begin__ = 85;
            double bAIC(0.0);
            (void) bAIC;  // dummy to suppress unused var warning

            stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(bAIC,DUMMY_VAR__);


            current_statement_begin__ = 87;
            stan::math::assign(npars, ((nSampledCells + nSampledCells) + 3));
            current_statement_begin__ = 90;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 91;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 92;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 93;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 96;
            stan::math::assign(expRec, add(elt_multiply(elt_multiply(psi_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psi_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 97;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 100;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 102;
                stan::math::assign(get_base1_lhs(pp,ncell,"pp",1), exp(((log(get_base1(psi_Sampled,ncell,"psi_Sampled",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1))) - log_mix(get_base1(psi_Sampled,ncell,"psi_Sampled",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1)),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 108;
                if (as_bool(bernoulli_rng(get_base1(pp,ncell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 109;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 1);
                    current_statement_begin__ = 110;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), get_base1(p,ncell,"p",1));
                    current_statement_begin__ = 111;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1), base_rng__));
                    current_statement_begin__ = 112;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 115;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 0);
                    current_statement_begin__ = 116;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 117;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 118;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 121;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 125;
            stan::math::assign(psi, (sum(cellpres_i) / nSampledCells));

            // validate generated quantities
            current_statement_begin__ = 71;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
            }
            current_statement_begin__ = 72;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
            }
            current_statement_begin__ = 73;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
            }
            current_statement_begin__ = 75;
            check_greater_or_equal(function__,"psi",psi,0);
            check_less_or_equal(function__,"psi",psi,1);
            current_statement_begin__ = 76;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
                check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
            }
            current_statement_begin__ = 77;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
                check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
            }
            current_statement_begin__ = 78;
            check_greater_or_equal(function__,"pp",pp,0);
            check_less_or_equal(function__,"pp",pp,1);
            current_statement_begin__ = 79;
            current_statement_begin__ = 80;
            current_statement_begin__ = 81;
            current_statement_begin__ = 82;
            current_statement_begin__ = 83;
            current_statement_begin__ = 84;
            current_statement_begin__ = 85;

            // write generated quantities
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
            }
        vars__.push_back(psi);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pp[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
            }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psiipiq";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_psiipiq_CAR_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psiipiq_CAR");
    reader.add_event(200, 200, "end", "model_psiipiq_CAR");
    return reader;
}

template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 20;
        validate_non_negative_index("phit_D", "n", n);
        Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_D(static_cast<Eigen::VectorXd::Index>(n));
        (void) phit_D;  // dummy to suppress unused var warning

        stan::math::initialize(phit_D, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phit_D,DUMMY_VAR__);
        current_statement_begin__ = 21;
        validate_non_negative_index("phit_W", "n", n);
        Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_W(static_cast<Eigen::VectorXd::Index>(n));
        (void) phit_W;  // dummy to suppress unused var warning

        stan::math::initialize(phit_W, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phit_W,DUMMY_VAR__);
        current_statement_begin__ = 22;
        validate_non_negative_index("ldet_terms", "n", n);
        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ldet_terms(static_cast<Eigen::VectorXd::Index>(n));
        (void) ldet_terms;  // dummy to suppress unused var warning

        stan::math::initialize(ldet_terms, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ldet_terms,DUMMY_VAR__);


        current_statement_begin__ = 24;
        stan::math::assign(phit_D, transpose(elt_multiply(phi,D_sparse)));
        current_statement_begin__ = 25;
        stan::math::assign(phit_W, rep_row_vector(0,n));
        current_statement_begin__ = 26;
        for (int i = 1; i <= W_n; ++i) {

            current_statement_begin__ = 27;
            stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phi",1)));
            current_statement_begin__ = 28;
            stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phi",1)));
        }
        current_statement_begin__ = 31;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 31;
            stan::math::assign(get_base1_lhs(ldet_terms,i,"ldet_terms",1), log1m((alpha * get_base1(lambda,i,"lambda",1))));
        }
        current_statement_begin__ = 32;
        return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (((n * log(tau)) + sum(ldet_terms)) - (tau * (multiply(phit_D,phi) - (alpha * multiply(phit_W,phi)))))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    return sparse_car_lpdf<false>(phi,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__);
}


struct sparse_car_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) const {
        return sparse_car_lpdf(phi, tau, alpha, W_sparse, D_sparse, lambda, n, W_n, pstream__);
    }
};

class model_psiipiq_CAR : public prob_grad {
private:
    int nSampledCells;
    vector<int> sampledId;
    int nNotSampled;
    vector<int> notSampledId;
    int n;
    int W_n;
    vector<vector<int> > W_sparse;
    vector_d D_sparse;
    vector_d lambda;
    vector<int> N;
    vector<int> y;
    double minP;
public:
    model_psiipiq_CAR(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psiipiq_CAR(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psiipiq_CAR_namespace::model_psiipiq_CAR";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
            nSampledCells = int(0);
            vals_i__ = context__.vals_i("nSampledCells");
            pos__ = 0;
            nSampledCells = vals_i__[pos__++];
            current_statement_begin__ = 42;
            validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "sampledId", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
            sampledId = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("sampledId");
            pos__ = 0;
            size_t sampledId_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < sampledId_limit_0__; ++i_0__) {
                sampledId[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "nNotSampled", "int", context__.to_vec());
            nNotSampled = int(0);
            vals_i__ = context__.vals_i("nNotSampled");
            pos__ = 0;
            nNotSampled = vals_i__[pos__++];
            current_statement_begin__ = 44;
            validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
            context__.validate_dims("data initialization", "notSampledId", "int", context__.to_vec(nNotSampled));
            validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
            notSampledId = std::vector<int>(nNotSampled,int(0));
            vals_i__ = context__.vals_i("notSampledId");
            pos__ = 0;
            size_t notSampledId_limit_0__ = nNotSampled;
            for (size_t i_0__ = 0; i_0__ < notSampledId_limit_0__; ++i_0__) {
                notSampledId[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "W_n", "int", context__.to_vec());
            W_n = int(0);
            vals_i__ = context__.vals_i("W_n");
            pos__ = 0;
            W_n = vals_i__[pos__++];
            current_statement_begin__ = 47;
            validate_non_negative_index("W_sparse", "W_n", W_n);
            validate_non_negative_index("W_sparse", "2", 2);
            context__.validate_dims("data initialization", "W_sparse", "int", context__.to_vec(W_n,2));
            validate_non_negative_index("W_sparse", "W_n", W_n);
            validate_non_negative_index("W_sparse", "2", 2);
            W_sparse = std::vector<std::vector<int> >(W_n,std::vector<int>(2,int(0)));
            vals_i__ = context__.vals_i("W_sparse");
            pos__ = 0;
            size_t W_sparse_limit_1__ = 2;
            for (size_t i_1__ = 0; i_1__ < W_sparse_limit_1__; ++i_1__) {
                size_t W_sparse_limit_0__ = W_n;
                for (size_t i_0__ = 0; i_0__ < W_sparse_limit_0__; ++i_0__) {
                    W_sparse[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 48;
            validate_non_negative_index("D_sparse", "n", n);
            context__.validate_dims("data initialization", "D_sparse", "vector_d", context__.to_vec(n));
            validate_non_negative_index("D_sparse", "n", n);
            D_sparse = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("D_sparse");
            pos__ = 0;
            size_t D_sparse_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < D_sparse_i_vec_lim__; ++i_vec__) {
                D_sparse[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 49;
            validate_non_negative_index("lambda", "n", n);
            context__.validate_dims("data initialization", "lambda", "vector_d", context__.to_vec(n));
            validate_non_negative_index("lambda", "n", n);
            lambda = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("lambda");
            pos__ = 0;
            size_t lambda_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < lambda_i_vec_lim__; ++i_vec__) {
                lambda[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 50;
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            N = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            size_t N_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
                N[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 51;
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            y = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 52;
            context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
            minP = double(0);
            vals_r__ = context__.vals_r("minP");
            pos__ = 0;
            minP = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 41;
            check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
            current_statement_begin__ = 42;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sampledId[k0__]",sampledId[k0__],1);
            }
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"nNotSampled",nNotSampled,0);
            current_statement_begin__ = 44;
            for (int k0__ = 0; k0__ < nNotSampled; ++k0__) {
                check_greater_or_equal(function__,"notSampledId[k0__]",notSampledId[k0__],1);
            }
            current_statement_begin__ = 45;
            check_greater_or_equal(function__,"n",n,1);
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"W_n",W_n,1);
            current_statement_begin__ = 47;
            for (int k0__ = 0; k0__ < W_n; ++k0__) {
                for (int k1__ = 0; k1__ < 2; ++k1__) {
                    check_greater_or_equal(function__,"W_sparse[k0__][k1__]",W_sparse[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"D_sparse",D_sparse,1);
            current_statement_begin__ = 49;
            current_statement_begin__ = 50;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
            }
            current_statement_begin__ = 51;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
            }
            current_statement_begin__ = 52;
            check_greater_or_equal(function__,"minP",minP,0);
            check_less_or_equal(function__,"minP",minP,1);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 60;
            validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 61;
            validate_non_negative_index("psi_NotSampled", "nNotSampled", nNotSampled);
            num_params_r__ += nNotSampled;
            current_statement_begin__ = 62;
            validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 63;
            ++num_params_r__;
            current_statement_begin__ = 64;
            ++num_params_r__;
            current_statement_begin__ = 65;
            validate_non_negative_index("odds", "3", 3);
            num_params_r__ += 3;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_psiipiq_CAR() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psi_Sampled")))
            throw std::runtime_error("variable psi_Sampled missing");
        vals_r__ = context__.vals_r("psi_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psi_Sampled", "vector_d", context__.to_vec(nSampledCells));
        vector_d psi_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psi_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("psi_NotSampled")))
            throw std::runtime_error("variable psi_NotSampled missing");
        vals_r__ = context__.vals_r("psi_NotSampled");
        pos__ = 0U;
        validate_non_negative_index("psi_NotSampled", "nNotSampled", nNotSampled);
        context__.validate_dims("initialization", "psi_NotSampled", "vector_d", context__.to_vec(nNotSampled));
        vector_d psi_NotSampled(static_cast<Eigen::VectorXd::Index>(nNotSampled));
        for (int j1__ = 0U; j1__ < nNotSampled; ++j1__)
            psi_NotSampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_NotSampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_NotSampled: ") + e.what());
        }

        if (!(context__.contains_r("p_raw")))
            throw std::runtime_error("variable p_raw missing");
        vals_r__ = context__.vals_r("p_raw");
        pos__ = 0U;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "p_raw", "vector_d", context__.to_vec(nSampledCells));
        vector_d p_raw(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            p_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,p_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p_raw: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "double", context__.to_vec());
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "3", 3);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(3));
        vector_d odds(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_Sampled;
            (void) psi_Sampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_NotSampled;
            (void) psi_NotSampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled,lp__);
            else
                psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  p_raw;
            (void) p_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                p_raw = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                p_raw = in__.vector_lub_constrain(0,1,nSampledCells);

            T__ tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.scalar_lb_constrain(0,lp__);
            else
                tau = in__.scalar_lb_constrain(0);

            T__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_lub_constrain(0,1,lp__);
            else
                alpha = in__.scalar_lub_constrain(0,1);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
            (void) odds;  // dummy to suppress unused var warning
            if (jacobian__)
                odds = in__.ordered_constrain(3,lp__);
            else
                odds = in__.ordered_constrain(3);


            // transformed parameters
            current_statement_begin__ = 70;
            T__ q;
            (void) q;  // dummy to suppress unused var warning

            stan::math::initialize(q, DUMMY_VAR__);
            stan::math::fill(q,DUMMY_VAR__);
            current_statement_begin__ = 71;
            T__ pmax;
            (void) pmax;  // dummy to suppress unused var warning

            stan::math::initialize(pmax, DUMMY_VAR__);
            stan::math::fill(pmax,DUMMY_VAR__);
            current_statement_begin__ = 72;
            T__ pmin;
            (void) pmin;  // dummy to suppress unused var warning

            stan::math::initialize(pmin, DUMMY_VAR__);
            stan::math::fill(pmin,DUMMY_VAR__);
            current_statement_begin__ = 73;
            T__ pRange;
            (void) pRange;  // dummy to suppress unused var warning

            stan::math::initialize(pRange, DUMMY_VAR__);
            stan::math::fill(pRange,DUMMY_VAR__);
            current_statement_begin__ = 74;
            validate_non_negative_index("psi_i", "n", n);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_i(static_cast<Eigen::VectorXd::Index>(n));
            (void) psi_i;  // dummy to suppress unused var warning

            stan::math::initialize(psi_i, DUMMY_VAR__);
            stan::math::fill(psi_i,DUMMY_VAR__);
            current_statement_begin__ = 75;
            validate_non_negative_index("p", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 76;
            T__ qRate;
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, DUMMY_VAR__);
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 77;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, DUMMY_VAR__);
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 79;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 80;
            stan::math::assign(pmin, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 81;
            stan::math::assign(pmax, inv_logit(get_base1(odds,3,"odds",1)));
            current_statement_begin__ = 84;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psi_Sampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 85;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psi_NotSampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 86;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 87;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 89;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 91;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 93;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            if (stan::math::is_uninitialized(q)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: q";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(pmax)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmax";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(pmin)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmin";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(pRange)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pRange";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < n; ++i0__) {
                if (stan::math::is_uninitialized(psi_i(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: psi_i" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(p(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: p" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            if (stan::math::is_uninitialized(qRate)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: qRate";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 70;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 71;
            check_greater_or_equal(function__,"pmax",pmax,minP);
            check_less_or_equal(function__,"pmax",pmax,1);
            current_statement_begin__ = 72;
            check_greater_or_equal(function__,"pmin",pmin,minP);
            check_less_or_equal(function__,"pmin",pmin,1);
            current_statement_begin__ = 73;
            check_greater_or_equal(function__,"pRange",pRange,0);
            check_less_or_equal(function__,"pRange",pRange,1);
            current_statement_begin__ = 74;
            check_greater_or_equal(function__,"psi_i",psi_i,0);
            check_less_or_equal(function__,"psi_i",psi_i,1);
            current_statement_begin__ = 75;
            check_greater_or_equal(function__,"p",p,0);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 76;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 77;

            // model body

            current_statement_begin__ = 107;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 108;
            lp_accum__.add(normal_log(pRange,0,0.10000000000000001));
            current_statement_begin__ = 110;
            lp_accum__.add(normal_log(pmin,0.5,0.25));
            current_statement_begin__ = 111;
            lp_accum__.add(normal_log(p_raw,1,0.25));
            current_statement_begin__ = 112;
            lp_accum__.add(normal_log(pmax,0.5,0.25));
            current_statement_begin__ = 115;
            lp_accum__.add(beta_log(psi_i,0.5,0.5));
            current_statement_begin__ = 116;
            lp_accum__.add(gamma_log(tau,2,2));
            current_statement_begin__ = 119;
            lp_accum__.add(lLh_cell);
            current_statement_begin__ = 126;
            lp_accum__.add(sparse_car_lpdf(psi_i,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psi_Sampled");
        names__.push_back("psi_NotSampled");
        names__.push_back("p_raw");
        names__.push_back("tau");
        names__.push_back("alpha");
        names__.push_back("odds");
        names__.push_back("q");
        names__.push_back("pmax");
        names__.push_back("pmin");
        names__.push_back("pRange");
        names__.push_back("psi_i");
        names__.push_back("p");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("cell");
        names__.push_back("psi");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nNotSampled);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psiipiq_CAR_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);
        vector_d p_raw = in__.vector_lub_constrain(0,1,nSampledCells);
        double tau = in__.scalar_lb_constrain(0);
        double alpha = in__.scalar_lub_constrain(0,1);
        vector_d odds = in__.ordered_constrain(3);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psi_Sampled[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nNotSampled; ++k_0__) {
            vars__.push_back(psi_NotSampled[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p_raw[k_0__]);
            }
        vars__.push_back(tau);
        vars__.push_back(alpha);
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(odds[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 70;
            double q(0.0);
            (void) q;  // dummy to suppress unused var warning

            stan::math::initialize(q, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(q,DUMMY_VAR__);
            current_statement_begin__ = 71;
            double pmax(0.0);
            (void) pmax;  // dummy to suppress unused var warning

            stan::math::initialize(pmax, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pmax,DUMMY_VAR__);
            current_statement_begin__ = 72;
            double pmin(0.0);
            (void) pmin;  // dummy to suppress unused var warning

            stan::math::initialize(pmin, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pmin,DUMMY_VAR__);
            current_statement_begin__ = 73;
            double pRange(0.0);
            (void) pRange;  // dummy to suppress unused var warning

            stan::math::initialize(pRange, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pRange,DUMMY_VAR__);
            current_statement_begin__ = 74;
            validate_non_negative_index("psi_i", "n", n);
            vector_d psi_i(static_cast<Eigen::VectorXd::Index>(n));
            (void) psi_i;  // dummy to suppress unused var warning

            stan::math::initialize(psi_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi_i,DUMMY_VAR__);
            current_statement_begin__ = 75;
            validate_non_negative_index("p", "nSampledCells", nSampledCells);
            vector_d p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 76;
            double qRate(0.0);
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 77;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 79;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 80;
            stan::math::assign(pmin, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 81;
            stan::math::assign(pmax, inv_logit(get_base1(odds,3,"odds",1)));
            current_statement_begin__ = 84;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psi_Sampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 85;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psi_NotSampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 86;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 87;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 89;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 91;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 93;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            current_statement_begin__ = 70;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 71;
            check_greater_or_equal(function__,"pmax",pmax,minP);
            check_less_or_equal(function__,"pmax",pmax,1);
            current_statement_begin__ = 72;
            check_greater_or_equal(function__,"pmin",pmin,minP);
            check_less_or_equal(function__,"pmin",pmin,1);
            current_statement_begin__ = 73;
            check_greater_or_equal(function__,"pRange",pRange,0);
            check_less_or_equal(function__,"pRange",pRange,1);
            current_statement_begin__ = 74;
            check_greater_or_equal(function__,"psi_i",psi_i,0);
            check_less_or_equal(function__,"psi_i",psi_i,1);
            current_statement_begin__ = 75;
            check_greater_or_equal(function__,"p",p,0);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 76;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 77;

            // write transformed parameters
        vars__.push_back(q);
        vars__.push_back(pmax);
        vars__.push_back(pmin);
        vars__.push_back(pRange);
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(psi_i[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p[k_0__]);
            }
        vars__.push_back(qRate);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 134;
            validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
            vector<int> sim_y(nSampledCells, 0);
            stan::math::fill(sim_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 135;
            validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
            vector<int> sim_true_y(nSampledCells, 0);
            stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 136;
            validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
            vector<int> sim_false_y(nSampledCells, 0);
            stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 137;
            int cell(0);
            (void) cell;  // dummy to suppress unused var warning

            stan::math::fill(cell, std::numeric_limits<int>::min());
            current_statement_begin__ = 139;
            double psi(0.0);
            (void) psi;  // dummy to suppress unused var warning

            stan::math::initialize(psi, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi,DUMMY_VAR__);
            current_statement_begin__ = 140;
            validate_non_negative_index("cellpres_i", "n", n);
            vector<double> cellpres_i(n, 0.0);
            stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(cellpres_i,DUMMY_VAR__);
            current_statement_begin__ = 141;
            validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
            vector<double> pCorr(nSampledCells, 0.0);
            stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pCorr,DUMMY_VAR__);
            current_statement_begin__ = 142;
            validate_non_negative_index("pp", "n", n);
            vector_d pp(static_cast<Eigen::VectorXd::Index>(n));
            (void) pp;  // dummy to suppress unused var warning

            stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pp,DUMMY_VAR__);
            current_statement_begin__ = 143;
            validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
            vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) expRec;  // dummy to suppress unused var warning

            stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(expRec,DUMMY_VAR__);
            current_statement_begin__ = 144;
            double chi_sq(0.0);
            (void) chi_sq;  // dummy to suppress unused var warning

            stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(chi_sq,DUMMY_VAR__);
            current_statement_begin__ = 145;
            double npars(0.0);
            (void) npars;  // dummy to suppress unused var warning

            stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(npars,DUMMY_VAR__);
            current_statement_begin__ = 146;
            double lLh(0.0);
            (void) lLh;  // dummy to suppress unused var warning

            stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh,DUMMY_VAR__);
            current_statement_begin__ = 147;
            double AIC(0.0);
            (void) AIC;  // dummy to suppress unused var warning

            stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AIC,DUMMY_VAR__);
            current_statement_begin__ = 148;
            double AICc(0.0);
            (void) AICc;  // dummy to suppress unused var warning

            stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AICc,DUMMY_VAR__);
            current_statement_begin__ = 149;
            double bAIC(0.0);
            (void) bAIC;  // dummy to suppress unused var warning

            stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(bAIC,DUMMY_VAR__);


            current_statement_begin__ = 151;
            stan::math::assign(npars, (((((nSampledCells + nNotSampled) + nSampledCells) + 1) + 1) + 3));
            current_statement_begin__ = 153;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 154;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 155;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 156;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 159;
            stan::math::assign(expRec, add(elt_multiply(elt_multiply(psi_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psi_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 160;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 163;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 165;
                stan::math::assign(cell, get_base1(sampledId,ncell,"sampledId",1));
                current_statement_begin__ = 166;
                stan::math::assign(get_base1_lhs(pp,cell,"pp",1), exp(((log(get_base1(psi_i,cell,"psi_i",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1))) - log_mix(get_base1(psi_i,cell,"psi_i",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1)),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 172;
                if (as_bool(bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 173;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 1);
                    current_statement_begin__ = 174;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), get_base1(p,ncell,"p",1));
                    current_statement_begin__ = 175;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1), base_rng__));
                    current_statement_begin__ = 176;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 179;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 0);
                    current_statement_begin__ = 180;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 181;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 182;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 185;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 189;
            stan::model::assign(pp, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        stan::model::rvalue(psi_i, stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), "psi_i"), 
                        "assigning variable pp");
            current_statement_begin__ = 191;
            for (int ncell = 1; ncell <= nNotSampled; ++ncell) {

                current_statement_begin__ = 192;
                stan::math::assign(cell, get_base1(notSampledId,ncell,"notSampledId",1));
                current_statement_begin__ = 193;
                stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__));
            }
            current_statement_begin__ = 197;
            stan::math::assign(psi, (sum(cellpres_i) / n));

            // validate generated quantities
            current_statement_begin__ = 134;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
            }
            current_statement_begin__ = 135;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
            }
            current_statement_begin__ = 136;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
            }
            current_statement_begin__ = 137;
            check_greater_or_equal(function__,"cell",cell,1);
            current_statement_begin__ = 139;
            check_greater_or_equal(function__,"psi",psi,0);
            check_less_or_equal(function__,"psi",psi,1);
            current_statement_begin__ = 140;
            for (int k0__ = 0; k0__ < n; ++k0__) {
                check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
                check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
            }
            current_statement_begin__ = 141;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
                check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
            }
            current_statement_begin__ = 142;
            check_greater_or_equal(function__,"pp",pp,0);
            check_less_or_equal(function__,"pp",pp,1);
            current_statement_begin__ = 143;
            current_statement_begin__ = 144;
            current_statement_begin__ = 145;
            current_statement_begin__ = 146;
            current_statement_begin__ = 147;
            current_statement_begin__ = 148;
            current_statement_begin__ = 149;

            // write generated quantities
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
            }
        vars__.push_back(cell);
        vars__.push_back(psi);
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(pp[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
            }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psiipiq_CAR";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_psiipq_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psiipq");
    reader.add_event(115, 115, "end", "model_psiipq");
    return reader;
}

class model_psiipq : public prob_grad {
private:
    int nSampledCells;
    vector<int> N;
    vector<int> y;
    double minP;
public:
    model_psiipq(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psiipq(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psiipq_namespace::model_psiipq";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
            nSampledCells = int(0);
            vals_i__ = context__.vals_i("nSampledCells");
            pos__ = 0;
            nSampledCells = vals_i__[pos__++];
            current_statement_begin__ = 3;
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            N = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            size_t N_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
                N[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            y = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
            minP = double(0);
            vals_r__ = context__.vals_r("minP");
            pos__ = 0;
            minP = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 2;
            check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
            current_statement_begin__ = 3;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
            }
            current_statement_begin__ = 4;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
            }
            current_statement_begin__ = 5;
            check_greater_or_equal(function__,"minP",minP,0);
            check_less_or_equal(function__,"minP",minP,1);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 13;
            validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 14;
            validate_non_negative_index("odds", "2", 2);
            num_params_r__ += 2;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_psiipq() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psi_Sampled")))
            throw std::runtime_error("variable psi_Sampled missing");
        vals_r__ = context__.vals_r("psi_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psi_Sampled", "vector_d", context__.to_vec(nSampledCells));
        vector_d psi_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psi_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "2", 2);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(2));
        vector_d odds(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_Sampled;
            (void) psi_Sampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
            (void) odds;  // dummy to suppress unused var warning
            if (jacobian__)
                odds = in__.ordered_constrain(2,lp__);
            else
                odds = in__.ordered_constrain(2);


            // transformed parameters
            current_statement_begin__ = 20;
            T__ q;
            (void) q;  // dummy to suppress unused var warning

            stan::math::initialize(q, DUMMY_VAR__);
            stan::math::fill(q,DUMMY_VAR__);
            current_statement_begin__ = 21;
            T__ p;
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 22;
            T__ qRate;
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, DUMMY_VAR__);
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 23;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, DUMMY_VAR__);
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 25;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 26;
            stan::math::assign(p, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 27;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 29;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            if (stan::math::is_uninitialized(q)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: q";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(p)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: p";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(qRate)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: qRate";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 20;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 21;
            check_greater_or_equal(function__,"p",p,minP);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 22;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 23;

            // model body

            current_statement_begin__ = 45;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 47;
            lp_accum__.add(beta_log(psi_Sampled,0.5,0.5));
            current_statement_begin__ = 49;
            lp_accum__.add(lLh_cell);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psi_Sampled");
        names__.push_back("odds");
        names__.push_back("q");
        names__.push_back("p");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("psi");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psiipq_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d odds = in__.ordered_constrain(2);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psi_Sampled[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(odds[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 20;
            double q(0.0);
            (void) q;  // dummy to suppress unused var warning

            stan::math::initialize(q, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(q,DUMMY_VAR__);
            current_statement_begin__ = 21;
            double p(0.0);
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 22;
            double qRate(0.0);
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 23;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 25;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 26;
            stan::math::assign(p, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 27;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 29;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            current_statement_begin__ = 20;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 21;
            check_greater_or_equal(function__,"p",p,minP);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 22;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 23;

            // write transformed parameters
        vars__.push_back(q);
        vars__.push_back(p);
        vars__.push_back(qRate);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 58;
            validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
            vector<int> sim_y(nSampledCells, 0);
            stan::math::fill(sim_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 59;
            validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
            vector<int> sim_true_y(nSampledCells, 0);
            stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 60;
            validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
            vector<int> sim_false_y(nSampledCells, 0);
            stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 62;
            double psi(0.0);
            (void) psi;  // dummy to suppress unused var warning

            stan::math::initialize(psi, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi,DUMMY_VAR__);
            current_statement_begin__ = 63;
            validate_non_negative_index("cellpres_i", "nSampledCells", nSampledCells);
            vector<double> cellpres_i(nSampledCells, 0.0);
            stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(cellpres_i,DUMMY_VAR__);
            current_statement_begin__ = 64;
            validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
            vector<double> pCorr(nSampledCells, 0.0);
            stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pCorr,DUMMY_VAR__);
            current_statement_begin__ = 65;
            validate_non_negative_index("pp", "nSampledCells", nSampledCells);
            vector_d pp(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) pp;  // dummy to suppress unused var warning

            stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pp,DUMMY_VAR__);
            current_statement_begin__ = 66;
            validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
            vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) expRec;  // dummy to suppress unused var warning

            stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(expRec,DUMMY_VAR__);
            current_statement_begin__ = 67;
            double chi_sq(0.0);
            (void) chi_sq;  // dummy to suppress unused var warning

            stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(chi_sq,DUMMY_VAR__);
            current_statement_begin__ = 68;
            double npars(0.0);
            (void) npars;  // dummy to suppress unused var warning

            stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(npars,DUMMY_VAR__);
            current_statement_begin__ = 69;
            double lLh(0.0);
            (void) lLh;  // dummy to suppress unused var warning

            stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh,DUMMY_VAR__);
            current_statement_begin__ = 70;
            double AIC(0.0);
            (void) AIC;  // dummy to suppress unused var warning

            stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AIC,DUMMY_VAR__);
            current_statement_begin__ = 71;
            double AICc(0.0);
            (void) AICc;  // dummy to suppress unused var warning

            stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AICc,DUMMY_VAR__);
            current_statement_begin__ = 72;
            double bAIC(0.0);
            (void) bAIC;  // dummy to suppress unused var warning

            stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(bAIC,DUMMY_VAR__);


            current_statement_begin__ = 74;
            stan::math::assign(npars, (nSampledCells + 2));
            current_statement_begin__ = 77;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 78;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 79;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 80;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 83;
            stan::math::assign(expRec, add(multiply(elt_multiply(psi_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psi_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 84;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 87;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 89;
                stan::math::assign(get_base1_lhs(pp,ncell,"pp",1), exp(((log(get_base1(psi_Sampled,ncell,"psi_Sampled",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p)) - log_mix(get_base1(psi_Sampled,ncell,"psi_Sampled",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 95;
                if (as_bool(bernoulli_rng(get_base1(pp,ncell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 96;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 1);
                    current_statement_begin__ = 97;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), p);
                    current_statement_begin__ = 98;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),p, base_rng__));
                    current_statement_begin__ = 99;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 102;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 0);
                    current_statement_begin__ = 103;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 104;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 105;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 108;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 112;
            stan::math::assign(psi, (sum(cellpres_i) / nSampledCells));

            // validate generated quantities
            current_statement_begin__ = 58;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
            }
            current_statement_begin__ = 59;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
            }
            current_statement_begin__ = 60;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
            }
            current_statement_begin__ = 62;
            check_greater_or_equal(function__,"psi",psi,0);
            check_less_or_equal(function__,"psi",psi,1);
            current_statement_begin__ = 63;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
                check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
            }
            current_statement_begin__ = 64;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
                check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
            }
            current_statement_begin__ = 65;
            check_greater_or_equal(function__,"pp",pp,0);
            check_less_or_equal(function__,"pp",pp,1);
            current_statement_begin__ = 66;
            current_statement_begin__ = 67;
            current_statement_begin__ = 68;
            current_statement_begin__ = 69;
            current_statement_begin__ = 70;
            current_statement_begin__ = 71;
            current_statement_begin__ = 72;

            // write generated quantities
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
            }
        vars__.push_back(psi);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pp[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
            }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psiipq";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_psiipq_CAR_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psiipq_CAR");
    reader.add_event(180, 180, "end", "model_psiipq_CAR");
    return reader;
}

template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 20;
        validate_non_negative_index("phit_D", "n", n);
        Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_D(static_cast<Eigen::VectorXd::Index>(n));
        (void) phit_D;  // dummy to suppress unused var warning

        stan::math::initialize(phit_D, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phit_D,DUMMY_VAR__);
        current_statement_begin__ = 21;
        validate_non_negative_index("phit_W", "n", n);
        Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_W(static_cast<Eigen::VectorXd::Index>(n));
        (void) phit_W;  // dummy to suppress unused var warning

        stan::math::initialize(phit_W, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phit_W,DUMMY_VAR__);
        current_statement_begin__ = 22;
        validate_non_negative_index("ldet_terms", "n", n);
        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ldet_terms(static_cast<Eigen::VectorXd::Index>(n));
        (void) ldet_terms;  // dummy to suppress unused var warning

        stan::math::initialize(ldet_terms, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ldet_terms,DUMMY_VAR__);


        current_statement_begin__ = 24;
        stan::math::assign(phit_D, transpose(elt_multiply(phi,D_sparse)));
        current_statement_begin__ = 25;
        stan::math::assign(phit_W, rep_row_vector(0,n));
        current_statement_begin__ = 26;
        for (int i = 1; i <= W_n; ++i) {

            current_statement_begin__ = 27;
            stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phi",1)));
            current_statement_begin__ = 28;
            stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phi",1)));
        }
        current_statement_begin__ = 31;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 31;
            stan::math::assign(get_base1_lhs(ldet_terms,i,"ldet_terms",1), log1m((alpha * get_base1(lambda,i,"lambda",1))));
        }
        current_statement_begin__ = 32;
        return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (((n * log(tau)) + sum(ldet_terms)) - (tau * (multiply(phit_D,phi) - (alpha * multiply(phit_W,phi)))))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    return sparse_car_lpdf<false>(phi,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__);
}


struct sparse_car_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) const {
        return sparse_car_lpdf(phi, tau, alpha, W_sparse, D_sparse, lambda, n, W_n, pstream__);
    }
};

class model_psiipq_CAR : public prob_grad {
private:
    int nSampledCells;
    vector<int> sampledId;
    int nNotSampled;
    vector<int> notSampledId;
    int n;
    int W_n;
    vector<vector<int> > W_sparse;
    vector_d D_sparse;
    vector_d lambda;
    vector<int> N;
    vector<int> y;
    double minP;
public:
    model_psiipq_CAR(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psiipq_CAR(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psiipq_CAR_namespace::model_psiipq_CAR";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
            nSampledCells = int(0);
            vals_i__ = context__.vals_i("nSampledCells");
            pos__ = 0;
            nSampledCells = vals_i__[pos__++];
            current_statement_begin__ = 42;
            validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "sampledId", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
            sampledId = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("sampledId");
            pos__ = 0;
            size_t sampledId_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < sampledId_limit_0__; ++i_0__) {
                sampledId[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "nNotSampled", "int", context__.to_vec());
            nNotSampled = int(0);
            vals_i__ = context__.vals_i("nNotSampled");
            pos__ = 0;
            nNotSampled = vals_i__[pos__++];
            current_statement_begin__ = 44;
            validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
            context__.validate_dims("data initialization", "notSampledId", "int", context__.to_vec(nNotSampled));
            validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
            notSampledId = std::vector<int>(nNotSampled,int(0));
            vals_i__ = context__.vals_i("notSampledId");
            pos__ = 0;
            size_t notSampledId_limit_0__ = nNotSampled;
            for (size_t i_0__ = 0; i_0__ < notSampledId_limit_0__; ++i_0__) {
                notSampledId[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "W_n", "int", context__.to_vec());
            W_n = int(0);
            vals_i__ = context__.vals_i("W_n");
            pos__ = 0;
            W_n = vals_i__[pos__++];
            current_statement_begin__ = 47;
            validate_non_negative_index("W_sparse", "W_n", W_n);
            validate_non_negative_index("W_sparse", "2", 2);
            context__.validate_dims("data initialization", "W_sparse", "int", context__.to_vec(W_n,2));
            validate_non_negative_index("W_sparse", "W_n", W_n);
            validate_non_negative_index("W_sparse", "2", 2);
            W_sparse = std::vector<std::vector<int> >(W_n,std::vector<int>(2,int(0)));
            vals_i__ = context__.vals_i("W_sparse");
            pos__ = 0;
            size_t W_sparse_limit_1__ = 2;
            for (size_t i_1__ = 0; i_1__ < W_sparse_limit_1__; ++i_1__) {
                size_t W_sparse_limit_0__ = W_n;
                for (size_t i_0__ = 0; i_0__ < W_sparse_limit_0__; ++i_0__) {
                    W_sparse[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 48;
            validate_non_negative_index("D_sparse", "n", n);
            context__.validate_dims("data initialization", "D_sparse", "vector_d", context__.to_vec(n));
            validate_non_negative_index("D_sparse", "n", n);
            D_sparse = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("D_sparse");
            pos__ = 0;
            size_t D_sparse_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < D_sparse_i_vec_lim__; ++i_vec__) {
                D_sparse[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 49;
            validate_non_negative_index("lambda", "n", n);
            context__.validate_dims("data initialization", "lambda", "vector_d", context__.to_vec(n));
            validate_non_negative_index("lambda", "n", n);
            lambda = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("lambda");
            pos__ = 0;
            size_t lambda_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < lambda_i_vec_lim__; ++i_vec__) {
                lambda[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 50;
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("N", "nSampledCells", nSampledCells);
            N = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            size_t N_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
                N[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 51;
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
            validate_non_negative_index("y", "nSampledCells", nSampledCells);
            y = std::vector<int>(nSampledCells,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = nSampledCells;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 52;
            context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
            minP = double(0);
            vals_r__ = context__.vals_r("minP");
            pos__ = 0;
            minP = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 41;
            check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
            current_statement_begin__ = 42;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sampledId[k0__]",sampledId[k0__],1);
            }
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"nNotSampled",nNotSampled,0);
            current_statement_begin__ = 44;
            for (int k0__ = 0; k0__ < nNotSampled; ++k0__) {
                check_greater_or_equal(function__,"notSampledId[k0__]",notSampledId[k0__],1);
            }
            current_statement_begin__ = 45;
            check_greater_or_equal(function__,"n",n,1);
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"W_n",W_n,1);
            current_statement_begin__ = 47;
            for (int k0__ = 0; k0__ < W_n; ++k0__) {
                for (int k1__ = 0; k1__ < 2; ++k1__) {
                    check_greater_or_equal(function__,"W_sparse[k0__][k1__]",W_sparse[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"D_sparse",D_sparse,1);
            current_statement_begin__ = 49;
            current_statement_begin__ = 50;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
            }
            current_statement_begin__ = 51;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
            }
            current_statement_begin__ = 52;
            check_greater_or_equal(function__,"minP",minP,0);
            check_less_or_equal(function__,"minP",minP,1);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 61;
            validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
            num_params_r__ += nSampledCells;
            current_statement_begin__ = 62;
            validate_non_negative_index("psi_NotSampled", "nNotSampled", nNotSampled);
            num_params_r__ += nNotSampled;
            current_statement_begin__ = 63;
            ++num_params_r__;
            current_statement_begin__ = 64;
            ++num_params_r__;
            current_statement_begin__ = 65;
            validate_non_negative_index("odds", "2", 2);
            num_params_r__ += 2;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_psiipq_CAR() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psi_Sampled")))
            throw std::runtime_error("variable psi_Sampled missing");
        vals_r__ = context__.vals_r("psi_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psi_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psi_Sampled", "vector_d", context__.to_vec(nSampledCells));
        vector_d psi_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psi_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("psi_NotSampled")))
            throw std::runtime_error("variable psi_NotSampled missing");
        vals_r__ = context__.vals_r("psi_NotSampled");
        pos__ = 0U;
        validate_non_negative_index("psi_NotSampled", "nNotSampled", nNotSampled);
        context__.validate_dims("initialization", "psi_NotSampled", "vector_d", context__.to_vec(nNotSampled));
        vector_d psi_NotSampled(static_cast<Eigen::VectorXd::Index>(nNotSampled));
        for (int j1__ = 0U; j1__ < nNotSampled; ++j1__)
            psi_NotSampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psi_NotSampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi_NotSampled: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "double", context__.to_vec());
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "2", 2);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(2));
        vector_d odds(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_Sampled;
            (void) psi_Sampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
            else
                psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_NotSampled;
            (void) psi_NotSampled;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled,lp__);
            else
                psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);

            T__ tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.scalar_lb_constrain(0,lp__);
            else
                tau = in__.scalar_lb_constrain(0);

            T__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_lub_constrain(0,1,lp__);
            else
                alpha = in__.scalar_lub_constrain(0,1);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
            (void) odds;  // dummy to suppress unused var warning
            if (jacobian__)
                odds = in__.ordered_constrain(2,lp__);
            else
                odds = in__.ordered_constrain(2);


            // transformed parameters
            current_statement_begin__ = 71;
            validate_non_negative_index("psi_i", "n", n);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_i(static_cast<Eigen::VectorXd::Index>(n));
            (void) psi_i;  // dummy to suppress unused var warning

            stan::math::initialize(psi_i, DUMMY_VAR__);
            stan::math::fill(psi_i,DUMMY_VAR__);
            current_statement_begin__ = 72;
            T__ q;
            (void) q;  // dummy to suppress unused var warning

            stan::math::initialize(q, DUMMY_VAR__);
            stan::math::fill(q,DUMMY_VAR__);
            current_statement_begin__ = 73;
            T__ p;
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 74;
            T__ qRate;
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, DUMMY_VAR__);
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 75;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, DUMMY_VAR__);
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 77;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psi_Sampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 78;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psi_NotSampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 79;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 80;
            stan::math::assign(p, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 81;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 83;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 85;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < n; ++i0__) {
                if (stan::math::is_uninitialized(psi_i(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: psi_i" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            if (stan::math::is_uninitialized(q)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: q";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(p)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: p";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(qRate)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: qRate";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
                if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 71;
            check_greater_or_equal(function__,"psi_i",psi_i,0);
            check_less_or_equal(function__,"psi_i",psi_i,1);
            current_statement_begin__ = 72;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 73;
            check_greater_or_equal(function__,"p",p,minP);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 74;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 75;

            // model body

            current_statement_begin__ = 99;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 100;
            lp_accum__.add(beta_log(psi_i,0.5,0.5));
            current_statement_begin__ = 101;
            lp_accum__.add(gamma_log(tau,2,2));
            current_statement_begin__ = 104;
            lp_accum__.add(lLh_cell);
            current_statement_begin__ = 106;
            lp_accum__.add(sparse_car_lpdf(psi_i,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psi_Sampled");
        names__.push_back("psi_NotSampled");
        names__.push_back("tau");
        names__.push_back("alpha");
        names__.push_back("odds");
        names__.push_back("psi_i");
        names__.push_back("q");
        names__.push_back("p");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("cell");
        names__.push_back("psi");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nNotSampled);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psiipq_CAR_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psi_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d psi_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);
        double tau = in__.scalar_lb_constrain(0);
        double alpha = in__.scalar_lub_constrain(0,1);
        vector_d odds = in__.ordered_constrain(2);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psi_Sampled[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nNotSampled; ++k_0__) {
            vars__.push_back(psi_NotSampled[k_0__]);
            }
        vars__.push_back(tau);
        vars__.push_back(alpha);
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(odds[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 71;
            validate_non_negative_index("psi_i", "n", n);
            vector_d psi_i(static_cast<Eigen::VectorXd::Index>(n));
            (void) psi_i;  // dummy to suppress unused var warning

            stan::math::initialize(psi_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi_i,DUMMY_VAR__);
            current_statement_begin__ = 72;
            double q(0.0);
            (void) q;  // dummy to suppress unused var warning

            stan::math::initialize(q, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(q,DUMMY_VAR__);
            current_statement_begin__ = 73;
            double p(0.0);
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 74;
            double qRate(0.0);
            (void) qRate;  // dummy to suppress unused var warning

            stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(qRate,DUMMY_VAR__);
            current_statement_begin__ = 75;
            validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
            vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) lLh_cell;  // dummy to suppress unused var warning

            stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh_cell,DUMMY_VAR__);


            current_statement_begin__ = 77;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psi_Sampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 78;
            stan::model::assign(psi_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psi_NotSampled, 
                        "assigning variable psi_i");
            current_statement_begin__ = 79;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 80;
            stan::math::assign(p, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 81;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 83;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 85;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psi_Sampled,cell,"psi_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }

            // validate transformed parameters
            current_statement_begin__ = 71;
            check_greater_or_equal(function__,"psi_i",psi_i,0);
            check_less_or_equal(function__,"psi_i",psi_i,1);
            current_statement_begin__ = 72;
            check_greater_or_equal(function__,"q",q,0);
            check_less_or_equal(function__,"q",q,1);
            current_statement_begin__ = 73;
            check_greater_or_equal(function__,"p",p,minP);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 74;
            check_greater_or_equal(function__,"qRate",qRate,0);
            check_less_or_equal(function__,"qRate",qRate,1);
            current_statement_begin__ = 75;

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(psi_i[k_0__]);
            }
        vars__.push_back(q);
        vars__.push_back(p);
        vars__.push_back(qRate);
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 114;
            validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
            vector<int> sim_y(nSampledCells, 0);
            stan::math::fill(sim_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 115;
            validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
            vector<int> sim_true_y(nSampledCells, 0);
            stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 116;
            validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
            vector<int> sim_false_y(nSampledCells, 0);
            stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
            current_statement_begin__ = 117;
            int cell(0);
            (void) cell;  // dummy to suppress unused var warning

            stan::math::fill(cell, std::numeric_limits<int>::min());
            current_statement_begin__ = 119;
            double psi(0.0);
            (void) psi;  // dummy to suppress unused var warning

            stan::math::initialize(psi, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi,DUMMY_VAR__);
            current_statement_begin__ = 120;
            validate_non_negative_index("cellpres_i", "n", n);
            vector<double> cellpres_i(n, 0.0);
            stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(cellpres_i,DUMMY_VAR__);
            current_statement_begin__ = 121;
            validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
            vector<double> pCorr(nSampledCells, 0.0);
            stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pCorr,DUMMY_VAR__);
            current_statement_begin__ = 122;
            validate_non_negative_index("pp", "n", n);
            vector_d pp(static_cast<Eigen::VectorXd::Index>(n));
            (void) pp;  // dummy to suppress unused var warning

            stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pp,DUMMY_VAR__);
            current_statement_begin__ = 123;
            validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
            vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
            (void) expRec;  // dummy to suppress unused var warning

            stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(expRec,DUMMY_VAR__);
            current_statement_begin__ = 124;
            double chi_sq(0.0);
            (void) chi_sq;  // dummy to suppress unused var warning

            stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(chi_sq,DUMMY_VAR__);
            current_statement_begin__ = 125;
            double npars(0.0);
            (void) npars;  // dummy to suppress unused var warning

            stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(npars,DUMMY_VAR__);
            current_statement_begin__ = 126;
            double lLh(0.0);
            (void) lLh;  // dummy to suppress unused var warning

            stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lLh,DUMMY_VAR__);
            current_statement_begin__ = 127;
            double AIC(0.0);
            (void) AIC;  // dummy to suppress unused var warning

            stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AIC,DUMMY_VAR__);
            current_statement_begin__ = 128;
            double AICc(0.0);
            (void) AICc;  // dummy to suppress unused var warning

            stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(AICc,DUMMY_VAR__);
            current_statement_begin__ = 129;
            double bAIC(0.0);
            (void) bAIC;  // dummy to suppress unused var warning

            stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(bAIC,DUMMY_VAR__);


            current_statement_begin__ = 131;
            stan::math::assign(npars, ((((nSampledCells + nNotSampled) + 1) + 1) + 2));
            current_statement_begin__ = 134;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 135;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 136;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 137;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 139;
            stan::math::assign(expRec, add(multiply(elt_multiply(psi_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psi_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 140;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 143;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 145;
                stan::math::assign(cell, get_base1(sampledId,ncell,"sampledId",1));
                current_statement_begin__ = 146;
                stan::math::assign(get_base1_lhs(pp,cell,"pp",1), exp(((log(get_base1(psi_i,cell,"psi_i",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p)) - log_mix(get_base1(psi_i,cell,"psi_i",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 152;
                if (as_bool(bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 153;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 1);
                    current_statement_begin__ = 154;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), p);
                    current_statement_begin__ = 155;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),p, base_rng__));
                    current_statement_begin__ = 156;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 159;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 0);
                    current_statement_begin__ = 160;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 161;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 162;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 165;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 169;
            stan::model::assign(pp, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        stan::model::rvalue(psi_i, stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), "psi_i"), 
                        "assigning variable pp");
            current_statement_begin__ = 171;
            for (int ncell = 1; ncell <= nNotSampled; ++ncell) {

                current_statement_begin__ = 172;
                stan::math::assign(cell, get_base1(notSampledId,ncell,"notSampledId",1));
                current_statement_begin__ = 173;
                stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__));
            }
            current_statement_begin__ = 177;
            stan::math::assign(psi, (sum(cellpres_i) / n));

            // validate generated quantities
            current_statement_begin__ = 114;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
            }
            current_statement_begin__ = 115;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
            }
            current_statement_begin__ = 116;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
            }
            current_statement_begin__ = 117;
            check_greater_or_equal(function__,"cell",cell,1);
            current_statement_begin__ = 119;
            check_greater_or_equal(function__,"psi",psi,0);
            check_less_or_equal(function__,"psi",psi,1);
            current_statement_begin__ = 120;
            for (int k0__ = 0; k0__ < n; ++k0__) {
                check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
                check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
            }
            current_statement_begin__ = 121;
            for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
                check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
                check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
            }
            current_statement_begin__ = 122;
            check_greater_or_equal(function__,"pp",pp,0);
            check_less_or_equal(function__,"pp",pp,1);
            current_statement_begin__ = 123;
            current_statement_begin__ = 124;
            current_statement_begin__ = 125;
            current_statement_begin__ = 126;
            current_statement_begin__ = 127;
            current_statement_begin__ = 128;
            current_statement_begin__ = 129;

            // write generated quantities
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
            }
        vars__.push_back(cell);
        vars__.push_back(psi);
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(pp[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
            }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psiipq_CAR";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




#endif
