% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_posterior.R
\name{compare_posterior}
\alias{compare_posterior}
\title{compare_posterior}
\usage{
compare_posterior(
  x,
  comparison = "nec",
  ecx_val = 10,
  type = "absolute",
  hormesis_def = "control",
  sig_val = 0.01,
  precision,
  x_range = NA
)
}
\arguments{
\item{x}{A named \code{\link[base]{list}} of objects of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}} returned by
\code{\link{bnec}}.}

\item{comparison}{The posterior predictions to compare, takes values of
"nec", "nsec", "ecx" or "fitted".}

\item{ecx_val}{The desired percentage effect value. This must be a value
between 1 and 99 (for type = "relative" and "absolute"), defaults to 10.}

\item{type}{A \code{\link[base]{character}} vector, taking values of
"relative", "absolute" (the default) or "direct". See Details.}

\item{hormesis_def}{A \code{\link[base]{character}} vector, taking values
of "max" or "control". See Details.}

\item{sig_val}{Probability value to use as the lower quantile to test
significance of the predicted posterior values.
against the lowest observed concentration (assumed to be the control), to
estimate NEC as an interpolated NOEC value from smooth ECx curves.}

\item{precision}{The number of unique x values over which to find ECx -
large values will make the ECx estimate more precise.}

\item{x_range}{A range of x values over which to consider extracting ECx.}
}
\value{
A named \code{\link[base]{list}} containing bootstrapped differences
in posterior predictions of the \code{\link{bayesnecfit}} or
\code{\link{bayesnecfit}} model fits contained in \code{x}. See Details.
}
\description{
Extracts posterior predicted values from a list of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}} model fits and
compares these via bootstrap re sampling.
}
\examples{
\dontrun{
library(bayesnec)
data(manec_example)
nec4param <- pull_out(manec_example, model = "nec4param")
ecx4param <- pull_out(manec_example, model = "ecx4param")
compare_posterior(list("nec" = ecx4param, "ecx" = nec4param), ecx_val = 50)
}

}
\seealso{
\code{\link{bnec}}
}
