% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{LogNormalModelParams}
\alias{LogNormalModelParams}
\alias{LinearAbxModel}
\title{Model Parameters for a Log Normal Model}
\usage{
LogNormalModelParams(
  modname,
  nstates = 2L,
  nmetro = 1L,
  forward = TRUE,
  cheat = FALSE,
  Insitu = NULL,
  SurveillanceTest = SurveillanceTestParams(),
  ClinicalTest = ClinicalTestParams(),
  OutOfUnitInfection = OutOfUnitInfectionParams(),
  InUnit = NULL,
  Abx = AbxParams(),
  AbxRate = AbxRateParams()
)

LinearAbxModel(..., InUnit = ABXInUnitParams())
}
\arguments{
\item{modname}{The name of the model used. Usually specified by specification functions.}

\item{nstates}{The number of states in the model.}

\item{nmetro}{The number of Metropolis-Hastings steps to take between outputs.}

\item{forward}{TODO}

\item{cheat}{TODO}

\item{Insitu}{In Situ Parameters}

\item{SurveillanceTest}{Surveillance Testing Parameters}

\item{ClinicalTest}{Clinical Testing Parameters}

\item{OutOfUnitInfection}{Out of Unit Infection Parameters}

\item{InUnit}{In Unit Parameters, should be a list of lists with parameters
for the acquisition, progression and clearance of the disease.}

\item{Abx}{Antibiotic Parameters}

\item{AbxRate}{Antibiotic Rate Parameters}

\item{...}{Additional arguments passed to LogNormalModelParams}
}
\value{
A list of parameters for the model.
}
\description{
Model Parameters for a Log Normal Model
}
\section{Functions}{
\itemize{
\item \code{LinearAbxModel()}: Linear Antibiotic Model Alias

}}
\examples{
LogNormalModelParams("LogNormalModel")
}
