% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportFunctions.R
\name{filterWgts}
\alias{filterWgts}
\title{Create filter weights}
\usage{
filterWgts(n = NULL, type = "weighted")
}
\arguments{
\item{n}{number of values}

\item{type}{Averaging method ("uniform" [even], "weighted" [default], or "centered") for creating weights.}
}
\value{
Returns vector of weights
}
\description{
Create filter weights. Typically used to compute even,
weighted, or center-weighted averages for smoothing. Can
be used as a vector of weights in stats::filter
}
\examples{
wgts<- filterWgts(0,"uniform")
wgts<- filterWgts(7,"uniform")
wgts<- filterWgts(7,"centered")
wgts<- filterWgts(7,"weighted")
x <- 1:100
filter(x, filterWgts(7,"weighted"), sides=1)
}
\keyword{internal}
