% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_medianStats.R
\name{median.lcens}
\alias{median.lcens}
\alias{median.mcens}
\alias{median.qw}
\alias{median.mcens}
\alias{median.qw}
\title{Median Value}
\usage{
\method{median}{lcens}(x, na.rm = FALSE, ...)

\method{median}{mcens}(x, na.rm = FALSE, ...)

\method{median}{qw}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{the censored data object.}

\item{na.rm}{remove missing values before computation?}

\item{\dots}{potentially further arguments for methods; not used in the default or lcens method.}
}
\value{
A vector of length one representing the sample median.
}
\description{
Computes the sample median: methods for "lcens," "mcens," and "qw" data.
}
\note{
The median is computed using the flipped Kaplan-Meier method described
in Helsel (2012).
}
\examples{
median(as.lcens(1:4, 2))

}
\references{
Helsel, D.R. 2012, Statistics for censored environmental data 
using Minitab and R: New York, Wiley, 324 p.\cr
}
\keyword{censored}
\keyword{internal}
\keyword{univariate}
