% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbl.R
\docType{package}
\name{bbl-package}
\alias{bbl-package}
\alias{_PACKAGE}
\title{bbl: Boltzmann Bayes Learner}
\description{
Supervised learning using Boltzmann Bayes model inference, 
    which extends naive Bayes model to include interactions. Enables 
    classification of data into multiple response groups based on a large 
    number of discrete predictors that can take factor values of 
    heterogeneous levels. Either pseudo-likelihood and mean field 
    inference can be used with L2 regularization, cross-validation, and 
    prediction on new data. 
    Woo et al. (2016) <doi:10.1186/s12864-016-2871-3>.
}
\details{
A typical workflow consists of the following steps:
\enumerate{
\item Set up \code{bbl} object.
Prepare a data frame containing data to be used as training set.
Create a main object using data as input argument
(\code{\link{bbl}}).
\item Train the model.
See \code{\link{train}}.
Perform cross-validation (\code{\link{crossval}})
to optimize regularization.
\item Make prediction on new data.
See \code{\link{predict}}.
}
}
\author{
\strong{Maintainer}: Jun Woo \email{jwoo@umn.edu} (0000-0003-3220-2064)

Other contributors:
\itemize{
  \item Jinhua Wang [contributor]
}

}
\keyword{internal}
