% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dGaussian}
\alias{dGaussian}
\title{Density function of Gaussian distribution}
\usage{
dGaussian(x, mu, Sigma = NULL, A = NULL, LOG = TRUE)
}
\arguments{
\item{x}{matrix, when x is a numeric vector, it will be converted to a matrix with 1 column!}

\item{mu}{numeric, mean vector.}

\item{Sigma}{matrix, covariance matrix, one of Sigma and A should be non-NULL.}

\item{A}{matrix, the Cholesky decomposition of Sigma, an upper triangular matrix, one of Sigma and A should be non-NULL.}

\item{LOG}{logical, return log density of LOG=TRUE, default TRUE.}
}
\value{
A numeric vector.
}
\description{
Get the density of a set of  samples from a Gaussian distribution
}
\examples{
\donttest{
plot(
   dGaussian(x=seq(-5,5,length.out = 1000),mu = 0,Sigma = 1,LOG = FALSE)
   ,type = "l"
)
}
}
\seealso{
\code{\link{rGaussian}}
}
