% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dT}
\alias{dT}
\title{Density function for (multivariate) t distribution}
\usage{
dT(x, mu, Sigma = NULL, A = NULL, df = 1, LOG = TRUE)
}
\arguments{
\item{x}{matrix, when x is a numeric vector, it will be converted to a matrix with 1 column!}

\item{mu}{numeric, mean vector.}

\item{Sigma}{matrix, covariance matrix, one of Sigma and A should be non-NULL.}

\item{A}{matrix, the Cholesky decomposition of Sigma, an upper triangular matrix, one of Sigma and A should be non-NULL.}

\item{df}{numeric, degrees of freedom.}

\item{LOG}{logical, return log density of LOG=TRUE, default TRUE.}
}
\value{
A numeric vector, the probability densities.
}
\description{
Get the density of a set of samples from a t distribution
}
\examples{
\donttest{
plot(
   dT(x=seq(-5,5,length.out = 1000),mu = 0,Sigma = 1,LOG = FALSE)
   ,type = "l"
)
}
}
\seealso{
\code{\link{rT}}
}
