% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{logsumexp}
\alias{logsumexp}
\title{log sum exp}
\usage{
logsumexp(x)
}
\arguments{
\item{x}{matrix, the values in x a all logged. If x is a numeric vector, it will be converted to a matrix with 1 row.}
}
\value{
numeric, the logsumexp of each row of x.
}
\description{
For each row l of a matrix x, calculate log(sum(exp(l))).
}
\examples{
\donttest{
## Normalize the rows of x to make them sum up to 1
x <- matrix(runif(6,-1000,-20),nrow=2)
x <- x-logsumexp(x)
x <- exp(x)
rowSums(x)
}
}
