% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{dDir}
\alias{dDir}
\title{Density function for Dirichelt distribution}
\usage{
dDir(x, alpha, LOG = FALSE)
}
\arguments{
\item{x}{matrix or numeric vector, if matrix every row of x is an observation, if numeric vector, it's the same as a matrix with only one row.}

\item{alpha}{numeric, Dirichlet parameter.}

\item{LOG}{logical, return the log density if set to "TRUE".}
}
\value{
A numeric vector of density values.
}
\description{
Calculate the densities of a given set of Dirichlet samples. For a random vector x, the density function is defined as:
  1/Beta(alpha) prod_{i=1:p}  x_i^{alpha_i -1}
Where Beta() is the beta function. p is the dimension of x.
}
\examples{
x <- rDir(5,c(1,2,3)) #generate 5 samples with parameters c(1,2,3)
dDir(x,c(1,2,3))
dDir(x,c(1,2,3),LOG=TRUE)
}
\seealso{
\code{\link{rDir}}
}
