% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dPosterior.GaussianNIG}
\alias{dPosterior.GaussianNIG}
\title{Density function of the posterior distribution of a "GaussianNIG" object}
\usage{
\method{dPosterior}{GaussianNIG}(obj, beta, sigma2, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{beta}{numeric vector.}

\item{sigma2}{numeric.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the posterior density of (beta,sigma^2).
}
\description{
Generate the the density value of the posterior distribution of the following structure:
   \deqn{x ~ Gaussian(X beta,sigma^2)}
   \deqn{sigma^2 ~ InvGamma(a,b)}
   \deqn{beta ~ Gaussian(m,sigma^2 V)}
Where X is a row vector, or a design matrix where each row is an obervation. InvGamma() is the Inverse-Gamma distribution, Gaussian() is the Gaussian distribution. See \code{?dInvGamma} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
Posterior density is the density function of beta,sigma^2|a,b,m,V.
}
\examples{
obj <- GaussianNIG(gamma=list(m=c(0,0),V=diag(2),a=1,b=1))
dPosterior(obj = obj,beta=runif(2),sigma2=3)
}
\seealso{
\code{\link{GaussianNIG}}, \code{\link{rPosterior.GaussianNIG}}
}
