% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{dPosteriorPredictive.CatHDP2}
\alias{dPosteriorPredictive.CatHDP2}
\title{Posterior predictive density function of a "CatHDP" object}
\usage{
\method{dPosteriorPredictive}{CatHDP2}(obj, u, k, z, m, j, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "CatHDP" object.}

\item{u}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{k}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{z}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{m}{integer, group label.}

\item{j}{integer, subgroup label.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure:
     \deqn{G_m |eta ~ DP(eta,U), m = 1:M}
     \deqn{G_mj|gamma ~ DP(gamma,G_m), j = 1:J_m}
     \deqn{pi_mj|G_mj,alpha ~ DP(alpha,G_mj)}
     \deqn{z|pi_mj ~ Categorical(pi_mj)}
     \deqn{k|z,G_mj ~ Categorical(G_mj), if z is a sample from the base measure G_mj}
     \deqn{u|k,G_m ~ Categorical(G_m), if k is a sample from the base measure G_m}
where DP(eta,U) is a Dirichlet Process on positive integers, eta is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G_m) is a Dirichlet Process on integers with concentration parameter gamma and base measure G_m. DP(alpha,G_mj) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_mj. Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatHDP2, u, z and k can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatHDP" object. \cr
Posterior predictive density =  p(u,z,k|alpha,gamm,eta,U,G_mj,G_m).
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatHDP}}, \code{\link{dPosteriorPredictive.CatHDP}}
}
