% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{pdsDeterminant}
\alias{pdsDeterminant}
\title{determinant of a positive definite symmetric matrix}
\usage{
pdsDeterminant(S, LOG = FALSE)
}
\arguments{
\item{S}{a symmetric positive definitive matrix.}

\item{LOG}{logical, return log(det(S)) if TRUE, return det(S) if FALSE, default FALSE.}
}
\value{
A matrix, the determinant of "S".
}
\description{
Use Cholesky decomposition to calculate the determinant of S, where \eqn{S = A'A}, A is a upper diagonal matrix. det(S) = det(A)*det(A).
}
\examples{
Sigma = matrix(c(1.3,1,1,2),2,2)      # some positive definite symmetric matrix
pdsDeterminant(Sigma)                 # get inv(Sigma)
pdsDeterminant(Sigma,LOG=TRUE)        # get inv(Sigma)
pdsInverse(Sigma,returnUpper=TRUE)  # get inv(A), where Sigma=A'A, A is upper triangle
}
