% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare-data.R
\name{prepare_data}
\alias{prepare_data}
\title{Wrangle data to use for modelling input}
\usage{
prepare_data(
  strat_data = NULL,
  species_to_run = NULL,
  model = NULL,
  heavy_tailed = FALSE,
  n_knots = NULL,
  min_year = NULL,
  max_year = NULL,
  min_n_routes = 3,
  min_max_route_years = 3,
  min_mean_route_years = 1,
  strata_rem = NULL,
  quiet = FALSE,
  sampler = "jags",
  basis = "original",
  ...
)
}
\arguments{
\item{strat_data}{Large list of stratified data returned by \code{stratify()}}

\item{species_to_run}{Character string of the English name of the species to run}

\item{model}{Character string of model to be used.
Options are "slope", "firstdiff", "gam", "gamye.}

\item{heavy_tailed}{Logical indicating whether the extra-Poisson error distribution should be modeled as a t-distribution, with heavier tails than the standard normal distribution. Default is currently FALSE, but recent results suggest users should strongly consider setting this to TRUE, even though it requires much longer convergence times}

\item{n_knots}{Number of knots to be used in GAM function}

\item{min_year}{Minimum year to keep in analysis}

\item{max_year}{Maximum year to keep in analysis}

\item{min_n_routes}{Minimum routes per strata where species has been observed.
Defaults to 3}

\item{min_max_route_years}{Minimum number of years with non-zero observations
of species on at least 1 route. Defaults to 3}

\item{min_mean_route_years}{Minimum average of years per route with the
species observed. Defaults to 1.}

\item{strata_rem}{Strata to remove from analysis. Defaults to NULL}

\item{quiet}{Should progress bars be suppressed?}

\item{sampler}{Which MCMC sampling software to use. Currently bbsBayes only
supports "jags".}

\item{basis}{Which version of the basis-function to use for the GAM smooth, the default is "original" the same basis used in Smith and Edwards 2020 and "mgcv" is an alternate that uses the "tp" basis from the packages mgcv (also used in brms, and rstanarm). If using the "mgcv" option, the user may want to consider adjusting the prior distributions for the parameters and their precision}

\item{...}{Additional arguments}
}
\value{
List of data to be used for modelling, including:
  \item{model}{The model to be used}
  \item{heavy_tailed}{Logical indicating whether the extra-Poisson error distribution should be modeled as a t-distribution}
  \item{min_nu}{if heavy_tailed is TRUE, minimum value for truncated gamma on DF of t-distribution noise default is 0 and user must change manually after function is run}
  \item{ncounts}{The number of counts containing useful data for the species}
  \item{nstrata}{The number of strata used in the analysis}
  \item{ymin}{Minimum year used}
  \item{ymax}{Maximum year used}
  \item{nonzeroweight}{Proportion of routes in each strata with species obervation}
  \item{count}{Vector of counts for the species}
  \item{strat}{Vector of strata to be used in the analysis}
  \item{obser}{Vector of unique observer-route pairings}
  \item{year}{Vector of years for each count}
  \item{firstyr}{Vector of indicator variables as to whether an observer was a first year}
  \item{month}{vector of numeric month of observation}
  \item{day}{vector of numeric day of observation}
  \item{nobservers}{Total number of observer-route pairings}
  \item{fixedyear}{Median of all years (ymin:ymax), included only with slope and firstdiff models}
  \item{nknots}{Number of knots to use for smooting functions, included only with GAM}
  \item{X.basis}{Basis function for n smoothing functions, included only with GAM}
}
\description{
\code{prepare_data} subsets raw BBS data by selected species and
   and wrangles stratified data for use as input for models.
}
\examples{
# Toy example with Pacific Wren sample data
# First, stratify the sample data

strat_data <- stratify(by = "bbs_cws", sample_data = TRUE)

# Prepare the stratified data for use in a model. In this
#   toy example, we will set the minimum year as 2009 and
#   maximum year as 2018, effectively only setting up to
#   model 10 years of data. We will use the "first difference
#   model.
model_data <- prepare_data(strat_data = strat_data,
                           species_to_run = "Pacific Wren",
                           model = "firstdiff",
                           min_year = 2009,
                           max_year = 2018)

# You can also specify the GAM model, with an optional number of
# knots to use for the GAM basis.
# By default, the number of knots will be equal to the floor
# of the total unique years for the species / 4
model_data <- prepare_data(strat_data = strat_data,
                           species_to_run = "Pacific Wren",
                           model = "gam",
                           n_knots = 9)


}
