% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_by_poly.R
\name{raster_by_poly}
\alias{raster_by_poly}
\title{Overlay a SpatialPolygonsDataFrmae or sf polygons layer on a raster layer
and clip the raster to each polygon.}
\usage{
raster_by_poly(raster_layer, poly, poly_field, summarize = FALSE,
  parallel = FALSE, cores = NULL, ...)
}
\arguments{
\item{raster_layer}{the raster layer}

\item{poly}{a \code{SpatialPolygonsDataFrame} layer or \code{sf} layer}

\item{poly_field}{the field on which to split the \code{SpatialPolygonsDataFrame}}

\item{summarize}{Should the function summarise the raster values in each
polygon to a vector? Default \code{FALSE}}

\item{parallel}{process in parallel? Default \code{FALSE}. Not currently
available on Windows.}

\item{cores}{number of cores if doing parallel. Default \code{NULL} uses half the
number detected}

\item{...}{passed on to \code{doMC::registerDoMC}}
}
\value{
a list of \code{RasterLayers} if \code{summarize = FALSE} otherwise a list of
vectors.
}
\description{
Overlay a SpatialPolygonsDataFrmae or sf polygons layer on a raster layer
and clip the raster to each polygon.
}
