% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_by_variable_locality.R
\name{get_data_by_variable_locality}
\alias{get_data_by_variable_locality}
\title{Get data by variable Id for localities from BDL API}
\usage{
get_data_by_variable_locality(
  varId,
  unitParentId,
  year = NULL,
  lang = c("pl", "en"),
  ...
)
}
\arguments{
\item{varId}{A single variable id or vector of multiple variable id's. If multiple id's are used, some columns
are not available.. Use \code{\link{search_variables}} or \code{\link{get_variables}} to find variable id code.}

\item{unitParentId}{A 12 character NUTS id code of interested unit. Use \code{\link{search_units}} or
\code{\link{get_units}} to find unit id code. If \code{NULL} (default) and \code{unitLevel} not
set up, returns all available units for variable.}

\item{year}{A vector of years. If \code{NULL} (default) returns data for all available years.}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Retrieve data for a given variables for multiple unit localities
 from BDL with specified format.
}
\details{
Data to retrieve from
  \href{https://bdl.stat.gov.pl}{The
  BDL Web Services} can be filtered with arguments. To get JSON data from specified
  directory with custom filters use \code{\link{get_request}} directly.

  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
 \donttest{
   get_data_by_variable_locality(varId = "415", unitParentId = "011212006063")
   get_data_by_variable_locality("420", year = "2008", unitParentId = "070000000000")
   
   # Multi variable download
   get_data_by_variable_locality(varId =c("415","430"), unitParentId = "011212006063")
}
}
\keyword{database}
\keyword{utilities}
