% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_hist.R
\name{coef_hist}
\alias{coef_hist}
\title{Graphs of the distribution of the coefficients over the model space}
\arguments{
\item{bma_list}{bma object (the result of the bma function)}

\item{BW}{Parameter indicating what method should be chosen to find bin widths for the histograms: \cr
\enumerate{
\item "FD" Freedman-Diaconis method \cr
\item "SC" Scott method \cr
\item "vec" user specified bin widths provided through a vector (parameter: binW)
}}

\item{binW}{A vector with bin widths to be used to construct histograms for the regressors. The vector must be of the size equal to total number of regressors. The vector with bin widths is used only if parameter BW="vec".}

\item{BN}{Parameter taking the values (default: BN = 0): \cr
1 - the histogram will be build based on the number of bins specified by the user through parameter num. If BN=1, the function ignores parameters BW. \cr
0 - the histogram will be build in line with parameter BW}

\item{num}{A vector with the numbers of bins used to be used to construct histograms for the regressors. The vector must be of the size equal to total number of regressors. The vector with bin widths is used only if parameter BN=1.}

\item{kernel}{A parameter taking the values (default: kernel = 0):\cr
1 - the function will build graphs using kernel density for the distribution of coefficients (with kernel=1, the function ignores parameters BW and BN) \cr
0 - the function will build regular histogram density for the distribution of coefficients}
}
\value{
A list with the graphs of the distribution of coefficients for all the considered regressors.
}
\description{
This function draws graphs of the distribution (in the form of histogram or kernel density) of the coefficients for all the considered regressors over the part of the model space that includes this regressors (half of the model space).
}
\examples{
\donttest{
library(magrittr)

data_prepared <- economic_growth[,1:7] \%>\%
   feature_standardization(timestamp_col = year, entity_col = country) \%>\%
   feature_standardization(timestamp_col = year, entity_col = country,
                           time_effects = TRUE, scale = FALSE)

model_space <- optimal_model_space(df = data_prepared, dep_var_col = gdp,
                                   timestamp_col = year, entity_col = country,
                                   init_value = 0.5)

bma_results <- bma(df = data_prepared, dep_var_col = gdp, timestamp_col = year,
entity_col = country, model_space = model_space, run_parallel = FALSE, dilution = 0)

coef_plots <- coef_hist(bma_results, kernel = 1)
}
}
