% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEM_bma.R
\name{likelihoods_summary}
\alias{likelihoods_summary}
\title{Approximate standard deviations for the models}
\usage{
likelihoods_summary(
  df,
  dep_var_col,
  timestamp_col,
  entity_col,
  model_space,
  exact_value = TRUE,
  model_prior = "uniform",
  run_parallel = FALSE
)
}
\arguments{
\item{df}{Data frame with data for the SEM analysis.}

\item{dep_var_col}{Column with the dependent variable}

\item{timestamp_col}{The name of the column with timestamps}

\item{entity_col}{Column with entities (e.g. countries)}

\item{model_space}{A matrix (with named rows) with each column corresponding
to a model. Each column specifies model parameters. Compare with
\link[bdsm]{optimal_model_space}}

\item{exact_value}{Whether the exact value of the likelihood should be
computed (\code{TRUE}) or just the proportional part (\code{FALSE}). Check
\link[bdsm]{SEM_likelihood} for details.}

\item{model_prior}{Which model prior to use. For now there are two options:
\code{'uniform'} and \code{'binomial-beta'}. Default is \code{'uniform'}.}

\item{run_parallel}{If \code{TRUE} the optimization is run in parallel using
the \link[parallel]{parApply} function. If \code{FALSE} (default value) the
base apply function is used. Note that using the parallel computing requires
setting the default cluster. See README.}
}
\value{
Matrix with columns describing likelihood and standard deviations for each
model. The first row is the likelihood for the model (computed using the
parameters in the provided model space). The second row is almost 1/2 * BIC_k
as in Raftery's Bayesian Model Selection in Social Research eq. 19 (see TODO
in the code below). The third row is model posterior probability. Then there
are rows with standard deviations for each parameter. After that we have rows
with robust standard deviation (not sure yet what exactly "robust" means).
}
\description{
Approximate standard deviations are computed for the models in the given
model space. Two versions are computed.
}
\examples{
\donttest{
  data_centered_scaled <-
    feature_standardization(df = bdsm::economic_growth[,1:7],
                            timestamp_col = year, entity_col = country)
  data_cross_sectional_standarized <-
    feature_standardization(df = data_centered_scaled, timestamp_col = year,
                            entity_col = country, time_effects = TRUE,
                            scale = FALSE)

    likelihoods_summary(df = data_cross_sectional_standarized,
                        dep_var_col = gdp, timestamp_col = year,
                        entity_col = country, model_space = economic_growth_ms)
}

}
