% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fcs.R
\name{remove_boundary_events}
\alias{remove_boundary_events}
\title{Remove boundary events.}
\usage{
remove_boundary_events(.flow_frame, .channels)
}
\arguments{
\item{.flow_frame}{A \code{flowFrame}. Usually the result of \code{read.FCS} from \code{flowCore}.}

\item{.channels}{A character vector with the channels to apply the filter to (mostly just forward and side scatter).}
}
\value{
A \code{FlowFrame} with border events removed.
}
\description{
A wrapper around application of \code{flowCore}'s \code{boundaryFilter}.
}
\examples{
\dontrun{
library(beadplexr)
library(flowCore)

.file_name <- system.file("extdata", "K2-C07-A7.fcs",
                          package = "beadplexr")
 # Load the fcs file
 .flow_frame <- read.FCS(filename = .file_name,
                         transformation = FALSE)

# Plot with all events
w_bdr <- .flow_frame@exprs
plot(w_bdr[, c("FSC-A", "SSC-A")])

# Remove boundary events
.flow_frame <- remove_boundary_events(.flow_frame,
                          .channels = c("FSC-A", "SSC-A"))

wo_bdr <- as.data.frame(.flow_frame@exprs)
plot(wo_bdr[, c("FSC-A", "SSC-A")])
}
}
\seealso{
\code{\link[flowCore]{boundaryFilter}} for comments on the filter.
}
\keyword{internal}
