% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_unique_ids.R
\name{has_unique_ids}
\alias{has_unique_ids}
\title{Determine if the XML text has unique parameter IDs}
\usage{
has_unique_ids(text)
}
\arguments{
\item{text}{the XML as text}
}
\value{
TRUE if all parameter IDs are unique, FALSE otherwise
}
\description{
Determine if the XML text has unique parameter IDs
}
\examples{
  library(testthat)

  line_1 <- "<parameter id=\"RealParameter.1\" ...</parameter>"
  line_2 <- "<parameter id=\"RealParameter.2\" ...</parameter>"
  expect_true(has_unique_ids(c(line_1, line_2)))
  expect_false(has_unique_ids(c(line_1, line_1)))
}
\seealso{
to obtain the duplicate parameter IDs, use
  \code{\link{get_duplicate_param_ids}}
}
\author{
Richèl J.C. Bilderbeek
}
