% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_version_cmd.R
\name{create_beast2_version_cmd_jar}
\alias{create_beast2_version_cmd_jar}
\title{Creates the terminal command to version a BEAST2 input file
using a call to the \code{launcher.jar} file}
\usage{
create_beast2_version_cmd_jar(beast2_jar_path = get_default_beast2_jar_path())
}
\arguments{
\item{beast2_jar_path}{name of the BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}
}
\value{
a character vector, of which the first element
  is the command (\code{java}, in this case),
  and the others are arguments (\code{-jar}, in this case, followed
  by more arguments.
}
\description{
Creates the terminal command to version a BEAST2 input file
using a call to the \code{launcher.jar} file
}
\examples{
  if (is_beast2_installed()) {
    cmds <- create_beast2_version_cmd_jar()
    testit::assert(length(cmds) == 5)
    testit::assert(cmds[2] == "-cp")
  }
}
\author{
Richèl J.C. Bilderbeek
}
