% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_beast2_input_lines.R
\name{are_beast2_input_lines}
\alias{are_beast2_input_lines}
\title{Would these lines of text, when written to a file,
  result in a valid BEAST2 input file?}
\usage{
are_beast2_input_lines(
  lines,
  verbose = FALSE,
  method = ifelse(beautier::is_on_ci(), "deep", "fast"),
  beast2_path = get_default_beast2_path()
)
}
\arguments{
\item{lines}{lines of text}

\item{verbose}{if TRUE, additional information is displayed, that
is potentially useful in debugging}

\item{method}{the method to check. Can be 'deep' or 'fast'.
The 'deep' method uses BEAST2 to validate the complete file.
The 'fast' method uses some superficial tests (for example: if all
IDs are unique)}

\item{beast2_path}{name of either a BEAST2 binary file
(usually simply \code{beast})
or a BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}
}
\value{
TRUE if the text is valid, FALSE if not
}
\description{
Would these lines of text, when written to a file,
  result in a valid BEAST2 input file?
}
\examples{
if (is_beast2_installed() && beautier::is_on_ci()) {
  are_beast2_input_lines(get_beastier_path("anthus_2_4.xml"))

  remove_beaustier_folders()
}
check_empty_beaustier_folders()
}
\seealso{
Use \code{\link{is_beast2_input_file}} to check a file
}
\author{
Richèl J.C. Bilderbeek
}
