% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_first_clock_model_index.R
\name{get_first_clock_model_index}
\alias{get_first_clock_model_index}
\title{Get the index of a clock model with a list of clock models}
\usage{
get_first_clock_model_index(clock_model, clock_models)
}
\arguments{
\item{clock_model}{a clock model,
as returned by \code{\link{create_clock_model}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}
}
\value{
the index of the first clock models with the same ID,
  NULL if such a clock model is absent
}
\description{
Get the index of a clock model with a list of clock models
}
\examples{
  a <- create_strict_clock_model(id = 1)
  b <- create_rln_clock_model(id = 2)
  ab <- list(a, b)
  testit::assert(beautier:::get_first_clock_model_index(a, ab) == 1)
  testit::assert(beautier:::get_first_clock_model_index(b, ab) == 2)
}
\author{
Richel J.C. Bilderbeek
}
