% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_default_mcmc.R
\name{is_default_mcmc}
\alias{is_default_mcmc}
\title{Determine if the MCMC is a default MCMC}
\usage{
is_default_mcmc(mcmc)
}
\arguments{
\item{mcmc}{one MCMC.
Use \code{\link{create_mcmc}} to create an MCMC.
Use \code{\link{create_ns_mcmc}} to create an MCMC
  for a Nested Sampling run.
Use \code{\link{check_mcmc}} to check if an MCMC is valid.
Use \code{\link{rename_mcmc_filenames}} to rename the filenames in an MCMC.}
}
\value{
TRUE if the MCMC is a default MCMC
}
\description{
Determine if the MCMC is a default MCMC
}
\examples{
if (is_on_ci()) {

  check_empty_beautier_folder()

  # TRUE: An MCMC created by 'create_mcmc' is default.
  is_default_mcmc(create_mcmc())

  # FALSE: An MCMC created by 'create_ns_mcmc' is not
  is_default_mcmc(create_ns_mcmc())

  check_empty_beautier_folder()
}
}
\author{
Richèl J.C. Bilderbeek
}
