% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pies.R
\name{pies}
\alias{pies}
\title{Practically Important Effect Sizes}
\usage{
pies(
  data = NULL,
  controlCol = NULL,
  expCol = NULL,
  d = NULL,
  cer = NULL,
  r = 1,
  n = NULL,
  threshold = NULL,
  mean = 0,
  sd = 1,
  bootstrapA = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{data}{Optionally, if you want to get A, a data frame.}

\item{controlCol, expCol}{Optionally, if you want to get A, the names of
the columns with control and experimental data.}

\item{d}{Cohen's d.}

\item{cer}{The control even rate (see \code{\link[behaviorchange:nnt]{behaviorchange::nnt()}}).}

\item{r, threshold, mean, sd}{Arguments for the \code{\link[behaviorchange:nnt]{behaviorchange::nnt()}}
function.}

\item{n}{The sample size.}

\item{bootstrapA}{Whether to use bootstrapping to compute A.}

\item{conf.level}{The confidence level of confidence intervals.}
}
\value{
A dataframe with all values.
}
\description{
Practically Important Effect Sizes
}
\examples{
pies(d = .5, n = 100, cer = .2, threshold = 2);
}
