% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiralDateAnim.R
\name{spiralDateAnim}
\alias{spiralDateAnim}
\title{Animated spiral graph}
\usage{
spiralDateAnim(dates, values, data, steps = 100, sleep = 0,
  progbar = TRUE, ...)
}
\arguments{
\item{dates, values, data}{Input as in \code{\link{spiralDate}}}

\item{steps}{Number of steps (images) in animation. DEFAULT: 100}

\item{sleep}{Pause time between frames, in seconds, passed to \code{\link{Sys.sleep}}. DEFAULT: 0}

\item{progbar}{Should a progress bar be drawn? Useful if you have a large dataset or many steps. DEFAULT: TRUE}

\item{\dots}{Further arguments passed to \code{\link{spiralDate}}}
}
\description{
Animation of (daily) time series along spiral
}
\examples{

set.seed(42)
x <- as.Date("1985-01-01")+0:5000
y <- cumsum(rnorm(5001))+50
y <- y + sin(0:5000/366*2*pi)*max(abs(y))/2
plot(x,y)

spiralDateAnim(x,y, steps=10, sleep=0.01) # 0.05 might be smoother...
spiralDateAnim(x,y, steps=20)

\dontrun{
## Rcmd check --as-cran doesn't like to open external devices such as pdf,
## so this example is excluded from running in the checks.
pdf("spiralDateAnimation.pdf")
spiralDateAnim(x,y, main="Example Transition", col=divPal(100), format=" ")
dev.off()

# if you have FFmpeg installed, you can use the animation package like this:
library2(animation)
saveVideo(spiralDateAnim(x,y, steps=300), video.name="spiral_anim.mp4", interval=0.1,
    ffmpeg="C:/Program Files/R/ffmpeg/bin/ffmpeg.exe")

}

}
\seealso{
\code{\link{spiralDate}}, \code{\link{linLogHist}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2016
}
\keyword{aplot}
\keyword{chron}
\keyword{color}
\keyword{hplot}
