% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par_sapply.R
\name{par_sapply}
\alias{par_sapply}
\title{cross-platform parallel processing with progbar}
\usage{
par_sapply(
  X,
  FUN,
  nc = NULL,
  pb = TRUE,
  simplify = TRUE,
  export_objects = NULL,
  ...
)
}
\arguments{
\item{X}{vector / list of values}

\item{FUN}{function to be executed with each element of \code{X}.}

\item{nc}{Integer: number of cores to be used in parallel.
DEFAULT: NULL (available cores)}

\item{pb}{Show progress bar with remaining time and at the end runtime? 
DEFAULT: TRUE}

\item{simplify}{Simplify output to vector/matrix if possible? DEFAULT: TRUE}

\item{export_objects}{For windows: Objects needed in \code{FUN}. DEFAULT: NULL}

\item{\dots}{Further arguments passed to \code{FUN} or 
\code{pbapply::\link[pbapply]{pbsapply}}}
}
\value{
vector/matrix, list if simplify=FALSE
}
\description{
Call \code{pbapply::\link[pbapply]{pbsapply}} 
             with nc default at number of cores available.
             Also, this works on Windows directly.
}
\examples{
\dontrun{ # Suppressed on CRAN checks as this is time-consuming
fun <- function(x) mean(rnorm(1e7))
pbapply::pbsapply(1:20, fun)
       par_sapply(1:20, fun)
          #sapply(1:20, fun)
}

}
\seealso{
\code{pbapply::\link[pbapply]{pbsapply}}, \code{\link{sapply}}, \code{\link{parallelCode}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Apr 2021
}
\keyword{iteration}
