% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yeojohnson.R
\name{yeojohnson}
\alias{yeojohnson}
\alias{predict.yeojohnson}
\alias{predict.yeojohnson}
\alias{print.yeojohnson}
\title{Yeo-Johnson Normalization}
\usage{
yeojohnson(x, eps = 0.001, standardize = TRUE, ...)

\method{predict}{yeojohnson}(object, newdata = NULL, inverse = FALSE, ...)

\method{print}{yeojohnson}(x, ...)
}
\arguments{
\item{x}{A vector to normalize with Yeo-Johnson}

\item{eps}{A value to compare lambda against to see if it is equal to zero}

\item{standardize}{If TRUE, the transformed values are also centered and
scaled, such that the transformation attempts a standard normal}

\item{...}{Additional arguments that can be passed to the estimation of the
lambda parameter (lower, upper)}

\item{object}{an object of class 'yeojohnson'}

\item{newdata}{a vector of data to be (reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}
}
\value{
A list of class \code{yeojohnson} with elements \item{x.t}{transformed
 original data} \item{x}{original data} \item{mean}{mean of vector post-YJ
 transformation} \item{sd}{sd of vector post-BC transformation}
 \item{lambda}{estimated lambda value for skew transformation}
 \item{n}{number of nonmissing observations} \item{norm_stat}{Pearson's P /
 degrees of freedom} \item{standardize}{Was the transformation standardized}

 The \code{predict} function returns the numeric value of the transformation
 performed on new data, and allows for the inverse transformation as well.
}
\description{
Perform a Yeo-Johnson Transformation and center/scale a vector to
 attempt normalization
}
\details{
\code{yeojohnson} estimates the optimal value of lambda for the
 Yeo-Johnson transformation. This transformation can be performed on new
 data, and inverted, via the \code{predict} function.

 The Yeo-Johnson is similar to the Box-Cox method, however it allows for the
 transformation of nonpositive data as well. The \code{step_YeoJohnson}
 function in the \code{recipes} package is another useful resource (see
 references).
}
\examples{

x <- rgamma(100, 1, 1)

yeojohnson_obj <- yeojohnson(x)
yeojohnson_obj
p <- predict(yeojohnson_obj)
x2 <- predict(yeojohnson_obj, newdata = p, inverse = TRUE)

all.equal(x2, x)

}
\references{
Yeo, I. K., & Johnson, R. A. (2000). A new family of power
 transformations to improve normality or symmetry. Biometrika.

 Max Kuhn and Hadley Wickham (2017). recipes: Preprocessing Tools to Create
 Design Matrices. R package version 0.1.0.9000.
 https://github.com/topepo/recipes
}
