% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestLogConstant.R
\name{bestLogConstant}
\alias{bestLogConstant}
\alias{predict.bestLogConstant}
\alias{print.bestLogConstant}
\title{Calculate and perform best normalizing log transformation (experimental)}
\usage{
bestLogConstant(x, a, standardize = TRUE, ...)

\method{predict}{bestLogConstant}(object, newdata = NULL, inverse = FALSE, ...)

\method{print}{bestLogConstant}(x, ...)
}
\arguments{
\item{x}{A vector to normalize}

\item{a}{(optional) a list of candidate constants to choose from}

\item{standardize}{If TRUE, the transformed values are also centered and
scaled, such that the transformation attempts a standard normal. This will
not change the normality statistic.}

\item{...}{additional arguments.}

\item{object}{an object of class 'bestLogConstant'}

\item{newdata}{a vector of data to be (reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}
}
\value{
A list of class \code{bestLogConstant} with elements

  \item{x.t}{transformed original data} \item{x}{original data}
  \item{norm_stats}{Pearson's Pearson's P / degrees of freedom}
  \item{method}{out-of-sample or in-sample, number of folds + repeats}
  \item{chosen_constant}{the chosen constant transformation (of class `log_x`)}
  \item{other_transforms}{the other transformations (of class `log_x`)}

  The \code{predict} function returns the numeric value of the transformation
  performed on new data, and allows for the inverse transformation as well.
}
\description{
Similar to bestNormalize, this selects the
  best candidate constant for a log transformation on the basis 
  of the Pearson P test statistic for normality. The
  transformation that has the lowest P (calculated on the transformed data)
  is selected. This function is currently in development and may not behave 
  as expected. 
  
  See details for more information.
}
\details{
\code{bestLogConstant} estimates the optimal normalizing constant 
  for a log transformation. This transformation can be performed on new data, and
  inverted, via the \code{predict} function.
}
\seealso{
\code{\link[bestNormalize]{bestNormalize}}, \code{\link{log_x}},
}
