% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaDelta-diff-beta-delta.R
\name{DiffBetaDelta}
\alias{DiffBetaDelta}
\title{Estimate Differences of Standardized Slopes
and the Corresponding Sampling Covariance Matrix}
\usage{
DiffBetaDelta(object)
}
\arguments{
\item{object}{Object of class \code{betadelta},
that is,
the output of the \code{BetaDelta()} function.}
}
\value{
Returns an object
of class \code{diffbetadelta} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{fit}{The argument \code{object}.}
\item{vcov}{Sampling covariance matrix of
differences of standardized slopes.}
\item{est}{Vector of
differences of standardized slopes.}
}
}
\description{
Estimate Differences of Standardized Slopes
and the Corresponding Sampling Covariance Matrix
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaDelta(object)
diff <- DiffBetaDelta(std)
# Methods -------------------------------------------------------
print(diff)
summary(diff)
coef(diff)
vcov(diff)
confint(diff, level = 0.95)
}
\seealso{
Other Beta Delta Functions: 
\code{\link{BetaDelta}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Delta Functions}
\keyword{betaDelta}
\keyword{diff}
