% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_lav_betaselect.R
\name{confint.lav_betaselect}
\alias{confint.lav_betaselect}
\title{Confidence Intervals for a
'lav_betaselect'-Class Object}
\usage{
\method{confint}{lav_betaselect}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{The output of \code{\link[=lav_betaselect]{lav_betaselect()}}.}

\item{parm}{Ignored due to the complexity in the
naming. The confidence intervals
of all parameters are always
returned.}

\item{level}{The level of confidence.
Ignored because the intervals should be
formed
when calling \code{\link[=lav_betaselect]{lav_betaselect()}}.}

\item{...}{Optional arguments.
Ignored.}
}
\value{
A two-column matrix of the confidence
intervals.
}
\description{
Return the confidence
intervals of betas-select in the
output of \code{\link[=lav_betaselect]{lav_betaselect()}}.
}
\details{
The type of
confidence intervals depends
on the call to \code{\link[=lav_betaselect]{lav_betaselect()}}.
This function does not recompute
the confidence interval.
}
\examples{

library(lavaan)
# Need to mean-center iv and mod
data_test_medmod$iv <- data_test_medmod$iv - mean(data_test_medmod$iv)
data_test_medmod$mod <- data_test_medmod$mod - mean(data_test_medmod$mod)
mod <-
"
med ~ iv + mod + iv:mod
dv ~ med + iv
"
fit <- sem(mod,
           data_test_medmod,
           fixed.x = TRUE)
summary(fit)
fit_beta <- lav_betaselect(fit,
                           to_standardize = c("iv", "dv"))
confint(fit_beta)

}
\seealso{
\code{\link[=lav_betaselect]{lav_betaselect()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
