% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{writePosteriorModeSexKaryotypes}
\alias{writePosteriorModeSexKaryotypes}
\title{Write a file with the posterior mode for each sex karyotype}
\usage{
writePosteriorModeSexKaryotypes(object, file, threshold_certainty = 0.9)
}
\arguments{
\item{object}{A bexy object.}

\item{file}{The name of the output file.}

\item{threshold_certainty}{The threshold for certainty on the posterior probabilities. All samples that have a posterior probability less than this threshold are classified as 'uncertain'.}
}
\value{
No return value, called for side effects.
}
\description{
Write a file with the posterior mode for each sex karyotype
}
\examples{
bex <- bexy()
tf <- tempfile(fileext = ".txt")
writePosteriorModeSexKaryotypes(bex, tf)
}
\seealso{
\code{\link{bexy}}
}
