% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bggSearch.R
\name{bggSearch}
\alias{bggSearch}
\title{API for BoardGameGeek search engine}
\description{
Search for items on the BoardGameGeek with a given query. See
  \code{\link{bggAPI}} for more details on inherited slots and methods.
}
\details{
Note that the result is trimmed to items with unique IDs. Due to
XML API2 `Search` returning multiple items for a single ID with different
types, variable \code{'type'} might be not accurately represented.
}
\references{
\href{https://boardgamegeek.com/wiki/page/BGG_XML_API2}{BoardGameGeek XML
  API2}
}
\section{Super class}{
\code{\link[bggAnalytics:bggAPI]{bggAnalytics::bggAPI}} -> \code{bggSearch}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{query}}{A single string with the wanted query.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{bggSearch$new()}}
\item \href{#method-print}{\code{bggSearch$print()}}
\item \href{#method-clone}{\code{bggSearch$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bggAnalytics" data-topic="bggAPI" data-id="expand">}\href{../../bggAnalytics/html/bggAPI.html#method-expand}{\code{bggAnalytics::bggAPI$expand()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bggAnalytics" data-topic="bggAPI" data-id="fetch">}\href{../../bggAnalytics/html/bggAPI.html#method-fetch}{\code{bggAnalytics::bggAPI$fetch()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bggAnalytics" data-topic="bggAPI" data-id="switch_namestyle">}\href{../../bggAnalytics/html/bggAPI.html#method-switch_namestyle}{\code{bggAnalytics::bggAPI$switch_namestyle()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Object initialization.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bggSearch$new(query, params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{a single string, query used to perform the search.}

\item{\code{params}}{a list of object parameters. If not all the parameters are
included in the list, default values are used (\code{NULL} instead of
the list is possible for all the default parameters). \cr
Following parameters are allowed for the \code{bggGames} class with
default values in parentheses:
\itemize{
    \item{\code{pretty_names}}{ - (\code{FALSE}) a boolean value,
    should the object should use pretty names,}
    \item{\code{type}}{ - (\code{NULL}) a single string, type of things
    to look for. Possible values: \code{'rpgitem'}, \code{'videogame'},
    \code{'boardgame'}, \code{'boardgameaccessory'},
    \code{'boardgameexpansion'}. \code{NULL} uses all possible values.}
    \item{\code{exact}}{ - (\code{FALSE}) a boolean value, should the
    results be restricted to items that match the \code{query} exactly.}
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bggSearch$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bggSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
