% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PriorFunctions.R
\name{setPriorParametersBerry}
\alias{setPriorParametersBerry}
\title{setPriorParametersBerry}
\usage{
setPriorParametersBerry(mu_mean, mu_sd, tau_scale)
}
\arguments{
\item{mu_mean}{A numeric for the mean of \eqn{\mu}}

\item{mu_sd}{A positive numeric for the standard deviation of \eqn{\mu}}

\item{tau_scale}{A positive numeric for the scale parameter of \eqn{\tau}}
}
\value{
A list with prior parameters of class \code{prior_parameters_list}
}
\description{
This function sets prior parameters for the analysis method \code{"berry"}
for use in \code{\link[bhmbasket]{performAnalyses}}.
}
\details{
This function sets the prior parameters for the method proposed by Berry et al. (2013).
Note that the implemented distribution of \eqn{\tau} is half-normal.
}
\examples{
 prior_parameters_berry <- setPriorParametersBerry(0, 1, 2)
}
\references{
Berry, Scott M., et al. "Bayesian hierarchical modeling of patient subpopulations:
efficient designs of phase II oncology clinical trials."
\emph{Clinical Trials} 10.5 (2013): 720-734.
}
\seealso{
\code{\link[bhmbasket]{performAnalyses}}
\code{\link[bhmbasket]{getPriorParameters}}
\code{\link[bhmbasket]{combinePriorParameters}}
\code{\link[bhmbasket]{setPriorParametersExNex}}
\code{\link[bhmbasket]{setPriorParametersExNexAdj}}
\code{\link[bhmbasket]{setPriorParametersPooled}}
\code{\link[bhmbasket]{setPriorParametersStratified}}
\code{\link[bhmbasket]{getMuVar}}
}
\author{
Stephan Wojciekowski
}
