% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scopus2df.R
\name{scopus2df}
\alias{scopus2df}
\title{Convert a SCOPUS Export file into a data frame}
\usage{
scopus2df(D)
}
\arguments{
\item{D}{is a character array containing data read from a SCOPUS Export file (in bibtex format).}
}
\value{
a data frame with cases corresponding to articles and variables to Field Tag in the original SCOPUS file.
}
\description{
It is an internal function used by \code{\link{convert2df}} to convert a SCOPUS Export file and create a data frame from it, 
with cases corresponding to articles and variables to Field Tag in the original file.
}
\examples{
# A SCOPUS Export file can be read using \\code{\\link{readFiles}} function:

# largechar <- readFiles('filename1.bib','filename2.bib2,...)

# filename.bib is a SCOPUS Export file in plain text format.

#largechar <- readFiles('http://www.bibliometrix.org/datasets/scopus.bib')


#scopus_df <- scopus2df(largechar)

}
\seealso{
\code{\link{isi2df}} for converting ISI Export file (in plain text format)

Other converting functions: \code{\link{bib2df}},
  \code{\link{cochrane2df}}, \code{\link{convert2df}},
  \code{\link{dimensions2df}}, \code{\link{isi2df}},
  \code{\link{isibib2df}}, \code{\link{pubmed2df}}
}
\concept{converting functions}
