% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigKRLS.R
\name{predict.bigKRLS}
\alias{predict.bigKRLS}
\title{predict.bigKRLS}
\usage{
\method{predict}{bigKRLS}(object, newdata, se.pred = FALSE,
  correct_SE = TRUE, ytest = NULL, ...)
}
\arguments{
\item{object}{bigKRLS output}

\item{newdata}{New data. Columns in newdata should be ordered identically to columns in X.}

\item{se.pred}{Calculate standard errors on predictions?}

\item{correct_SE}{If se.pred == TRUE, default is to use Neffective (if available) rather than model N in calculating uncertainty of predictions.}

\item{ytest}{Provide testing data to have it returned with the object. Optional. To automatically generate out-of-sample test statistics, use crossvalidate.bigKRLS() instead.}

\item{...}{ignore}
}
\value{
Returns bigKRLS_predicted list object.
}
\description{
Predict function for bigKRLS object. crossvalidate.bigKRLS() provides additional functionality.
}
\examples{
 
# set.seed(123)
# y <- as.matrix(ChickWeight$weight)
# X <- matrix(cbind(ChickWeight$Time, ChickWeight$Diet == 1), ncol = 2)
# N <- length(y)

# train <- sample(N, 100, replace = FALSE)
# outOfSample <- c(1:N)[-train]
# test <- sample(outOfSample, 10, replace = FALSE)

# fit <- bigKRLS(y[train], X[train,], instructions = FALSE) 
# p <- predict(fit, X[test,])
}
