% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_correction.r
\name{Monin.Obukhov.length}
\alias{Monin.Obukhov.length}
\title{Monin-Obukhov Length}
\usage{
Monin.Obukhov.length(data, Tair, pressure, ustar, H,
  constants = bigleaf.constants())
}
\arguments{
\item{data}{Data.frame or matrix containing all required variables}

\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{ustar}{Friction velocity (m s-1)}

\item{H}{Sensible heat flux (W m-2)}

\item{constants}{Kelvin - conversion degree Celsius to Kelvin \cr
cp - specific heat of air for constant pressure (J K-1 kg-1) \cr
k - von Karman constant (-) \cr
g - gravitational acceleration (m s-2)}
}
\value{
\item{L -}{Monin-Obukhov length (m)}
}
\description{


The Monin-Obukhov length (L) is given by:

             \deqn{L = - (\rho * cp * ustar^3 * Tair) / (k * g * H)}
             
             where \eqn{rho} is air density (kg m-3).
}
\note{
Note that L gets very small for very low ustar values with implications
      for subsequent functions using L as input. It is recommended to filter
      data and exclude low ustar values (ustar < ~0.2) beforehand.
}
\examples{
Monin.Obukhov.length(Tair=25,pressure=100,ustar=seq(0.2,1,0.1),H=seq(40,200,20))

}
\references{
Foken, T, 2008: Micrometeorology. Springer, Berlin, Germany.
}
\seealso{
\code{\link{stability.parameter}}
}
