% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_conversions.r
\name{LE.to.ET}
\alias{LE.to.ET}
\alias{ET.to.LE}
\title{Conversion between Latent Heat Flux and Evapotranspiration}
\usage{
LE.to.ET(LE, Tair)

ET.to.LE(ET, Tair)
}
\arguments{
\item{LE}{Latent heat flux (W m-2)}

\item{Tair}{Air temperature (deg C)}

\item{ET}{Evapotranspiration (kg m-2 s-1)}
}
\description{
converts evaporative water flux from mass (ET=evapotranspiration)
             to energy (LE=latent heat flux) units, or vice versa.
}
\details{
The conversions are given by:

\deqn{ET = LE/\lambda}

\deqn{LE = \lambda ET}

where \eqn{\lambda} is the latent heat of vaporization (J kg-1) as calculated by
\code{\link{latent.heat.vaporization}}.
}
\examples{
# LE of 200 Wm-2 and air temperature of 25degC
LE.to.ET(200,25)

}
