% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC.R
\name{AUC}
\alias{AUC}
\alias{AUCBoot}
\title{AUC}
\usage{
AUC(pred, target, digits = NULL)

AUCBoot(pred, target, nboot = 10000, seed = NA, digits = NULL)
}
\arguments{
\item{pred}{Vector of predictions.}

\item{target}{Vector of true labels (must have exactly two levels,
no missing values).}

\item{digits}{See \link{round}. Default doesn't use rounding.}

\item{nboot}{Number of bootstrap samples used to evaluate the 95\% CI.
Default is \code{1e4}.}

\item{seed}{See \link{set.seed}. Use it for reproducibility.
Default doesn't set any seed.}
}
\value{
The AUC, a probability, and possibly its 2.5\% and 97.5\% quantiles
(95\% CI).
}
\description{
Compute the Area Under the ROC Curve (AUC) of a predictor
and possibly its 95\% confidence interval.
}
\details{
Other packages provide ways to compute the AUC (see this
\href{http://stats.stackexchange.com/a/146174/135793}{answer}).
I chose to compute the AUC through its statistical definition as a
probability: \deqn{P(score(x_{case}) > score(x_{control})).}
Note that I consider equality between scores as a 50\%-probability of
one being greater than the other.
}
\examples{
set.seed(1)

AUC(c(0, 0), 0:1) # Equality of scores
AUC(c(0.2, 0.1, 1), c(0, 0, 1)) # Perfect AUC
x <- rnorm(100)
z <- rnorm(length(x), x, abs(x))
y <- as.numeric(z > 0)
print(AUC(x, y))
print(AUCBoot(x, y))

# Partial AUC
pAUC <- function(pred, target, p = 0.1) {
  val.min <- min(target)
  q <- quantile(pred[target == val.min], probs = 1 - p)
  ind <- (target != val.min) | (pred > q)
  bigstatsr::AUC(pred[ind], target[ind]) * p
}
pAUC(x, y)
pAUC(x, y, 0.2)
}
\seealso{
\link{wilcox.test}
}
