% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_ref_temp.R
\name{optimize_refTemp}
\alias{optimize_refTemp}
\title{Optimization of the Reference Temperature}
\usage{
optimize_refTemp(temp_ref0, lower, upper, inactivation_model, parms,
  temp_profile, parms_fix, n_times = 100)
}
\arguments{
\item{temp_ref0}{Initial value of the reference temperature to use for
the optimization.}

\item{lower}{Lower bound for the reference temperature.}

\item{upper}{Upper bound for the reference temperature.}

\item{inactivation_model}{Character identifying the inactivation model
to use for the calculation.}

\item{parms}{Numeric vector with the nominal values of the model parameters.}

\item{temp_profile}{Data frame describing the environmental conditions.}

\item{parms_fix}{Nominal value of the parameters not considered for the
sensitivity.}

\item{n_times}{Numeric value specifying the nombers of time points where 
the sensitivity functions will be calculated. 100 by default.}
}
\value{
The object returned by \code{\link{optim}}.
}
\description{
Finds the optimum value of the reference temperature which minimizes
the correlation between sensitivty functions of the model parameters.
}
\details{
The optimization is made using the \code{\link{optim}} function. The 
target for the optimization is the maximization of the determinant
of the correlation matrix between parameter sensitivities. The
Brent method is used, as it is the recommended one for unidimensional
optimization.  
The parameters z and D/delta cannot be fixed.
}
\examples{

parms <- c(delta_ref = 3.9, z = 4.2, p = 1, N0 = 1e6)
temp_profile <- data.frame(time = c(0, 60), temperature = c(30, 60))

optimize_refTemp(57, 50, 70, "Mafart", parms, temp_profile, c())

}

