% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyquist_velocity.R
\name{nyquist_velocity}
\alias{nyquist_velocity}
\title{Calculate Nyquist velocity for a given pulse repetition frequency (PRF)}
\usage{
nyquist_velocity(wavelength, prf1, prf2)
}
\arguments{
\item{wavelength}{Numeric. Radar wavelength, in cm.}

\item{prf1}{Numeric. Radar pulse repetition frequency, in Hz.}

\item{prf2}{Numeric. Alternate radar pulse repetition frequency for a radar
operating in dual-PRF mode, in Hz.}
}
\value{
Nyquist velocity, in m/s.
}
\description{
Calculates the Nyquist velocity given a radar's pulse repetition frequency
(PRF) and wavelength. When specifying two PRFs, the extended Nyquist velocity
is given for a radar using the dual-PRF technique.
}
\examples{
# Get Nyquist velocity at C-band (5.3 cm wavelength) and a PRF of 2000 Hz

# Get extended Nyquist velocity in a dual-PRF scheme using 2000 Hz and
# 1500 Hz PRFs
nyquist_velocity(5.3, 2000, 1500)
}
