% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-docs.R
\name{export_pdf}
\alias{export_pdf}
\title{Export BioCompute Object as PDF}
\usage{
export_pdf(x, file, wrap = FALSE, linewidth = 80, ...)
}
\arguments{
\item{x}{BioCompute Object JSON string from \code{\link{convert_json}}}

\item{file}{PDF output file path}

\item{wrap}{Should the long lines be wrapped?}

\item{linewidth}{Maximum linewidth when \code{wrap} is \code{TRUE}.}

\item{...}{Additional parameters for \code{\link[rmarkdown]{render}}.}
}
\value{
Path to the output file
}
\description{
Export BioCompute Object as PDF
}
\examples{
\dontrun{
file_pdf <- tempfile(fileext = ".pdf")
generate_example("HCV1a") \%>\%
  convert_json() \%>\%
  export_pdf(file_pdf)
}
}
