% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fast_crosstable}
\alias{fast_crosstable}
\title{Very fast 2d cross-tabulation}
\usage{
fast_crosstable(target_b, len_target, pos_target, feature)
}
\arguments{
\item{target_b}{target in bits (as per \code{\link[bit]{as.bit}}).}

\item{len_target}{length of the target vector.}

\item{pos_target}{number of positive cases in the target vector.}

\item{feature}{feature vector.}
}
\value{
a vector of length four: 
\enumerate{
\item target +, feature+
\item target +, feature-
\item target -, feature+
\item target -, feature-
}
}
\description{
Quickly cross-tabulates two binary vectors.
}
\details{
Input looks odd, but the function was build to be as fast 
as possible subroutine of \code{\link{calc_ig}}, which works on
many features but only one target.
}
\note{
Binary vector means a numeric vector with 0 or 1.
}
\examples{
tar <- sample(0L:1, 100, replace = TRUE)
feat <- sample(0L:1, 100, replace = TRUE)
library(bit) # used to code vector as bit
fast_crosstable(as.bit(tar), length(tar), sum(tar),  feat)
}
