findmaxline<-function(objects,Z.scale=1)
{
  N<-unique(as.vector(objects))
  N<-N[N!=0]
  #if(require(parallel))res<-mclapply(N,.findmaxline,objects)
  #if(!require(parallel))
    res<-lapply(N,.findmaxline,objects)
  re<-unlist(res)
  res<-array(re,c(8,length(N)))
  res<-t(res)
  res<-res[order(res[,1],decreasing=TRUE),]
  colnames(res)<-c("length","object","X1","X2","Y1","Y2","Z1","Z2")
  res<-data.frame(res)
  return(res)
}
.findmaxline<-function(i,objects)
  {
    object<-objects==i
    X<-range(which(apply(object,1,any)))
    Y<-range(which(apply(object,2,any)))
    Z<-range(which(apply(object,3,any)))
    object<-object[X[1]:X[2],Y[1]:Y[2],Z[1]:Z[2]]
    object<-array(object,c(X[2]-X[1]+1,Y[2]-Y[1]+1,Z[2]-Z[1]+1))
    edges<-find.edges(object)
    dist<-compute.distances(edges$coords,Z.scale=1)
    dist<-dist[order(dist[,3],decreasing=TRUE),]
    a<-0
    do<-FALSE
    while(!do)
    {
      a<-a+1
      do<-is.line(edges$coords[dist[a,1],],edges$coords[dist[a,2],],object)
    }
    corr=c(X[1],Y[1],Z[1])-1
  return(list("d"=dist[a,3],"N"=i,"c"=rbind(edges$coords[dist[a,1],]+corr,edges$coords[dist[a,2],]+corr)))
}