% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_clusters.R
\name{map_clusters}
\alias{map_clusters}
\title{Create a map of bioregions}
\usage{
map_clusters(clusters, geometry, write_clusters = FALSE, plot = TRUE, ...)
}
\arguments{
\item{clusters}{an object of class \code{bioregion.clusters} or a \code{data.frame}. If
a \code{data.frame} is used, the first column should represent the sites' ID, and
the next column(s) the clusters.}

\item{geometry}{a spatial object that can be handled by the \code{sf} package.
The first attribute should correspond to the sites' ID (see Details).}

\item{write_clusters}{a \code{boolean} indicating if the \code{clusters}
should be added in \code{geometry}.}

\item{plot}{a \code{boolean} indicating if the plot should be drawn.}

\item{...}{further arguments to be passed to \code{sf::plot()}}
}
\value{
One or several maps of bioregions if \code{plot = TRUE} and the
geometry with additional clusters' attributes if \code{write_clusters = TRUE}.
}
\description{
This plot function can be used to visualise bioregions based on a
bioregion.clusters object combined with a geometry (sf objects).
}
\details{
The \code{clusters} and \code{geometry} site IDs should correspond. They should
have the same type (i.e. \code{character} is cluster is a
\code{bioregion.clusters} object) and the site of \code{clusters} should be
included in the sites of \code{geometry}.
}
\examples{
data(fishmat)
data(fishsf)

net <- similarity(fishmat, metric = "Simpson")
clu <- netclu_greedy(net)
map <- map_clusters(clu, fishsf, write_clusters = TRUE, plot = FALSE)

}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}),
Boris Leroy (\email{leroy.boris@gmail.com}) and
Pierre Denelle (\email{pierre.denelle@gmail.com})
}
