% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selected_sites_SAC.R
\name{selected_sites_SAC}
\alias{selected_sites_SAC}
\title{Species accumulation curves from PAM_subset}
\usage{
selected_sites_SAC(PAM_subset, selection_type = "all", method = "exact", ...)
}
\arguments{
\item{PAM_subset}{object of class PAM_subset obtained using the function
\code{\link{subset_PAM}}.}

\item{selection_type}{type of selection to be considered when creating SAC
for elements in \code{PAM_subset}. Options are: "all", "random", "E", "G",
#' and "EG". The default, "all", uses all selection types present in
\code{PAM_subset}.}

\item{method}{(character) species accumulation method to be passed to
function \code{\link[vegan]{specaccum}}. Default = "exact".}

\item{...}{other arguments to be passed to function
\code{\link[vegan]{specaccum}}.}
}
\value{
A list of species accumulation curves (SACs, "\code{specaccum}" objects)
for all sets of selected sites according to option defined in
\code{selection_type}.
}
\description{
Creates species accumulation curves for each set of selected
sites contained in elements of \code{PAM_subset} that contain information of
species incidence (presence-absence).
}
\details{
Important details about the process performed to obtain each of the SACs can
be seen in the help for function \code{\link[vegan]{specaccum}}.
}
\examples{
# Data
data("b_pam", package = "biosurvey")
data("m_selection", package = "biosurvey")

# Subsetting base PAM according to selections
sub_pam_all <- subset_PAM(b_pam, m_selection, selection_type = "all")

SACs <- selected_sites_SAC(PAM_subset = sub_pam_all, selection_type = "all")
}
