% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census.R
\name{census_race_geo_table}
\alias{census_race_geo_table}
\title{Download Census Race Data}
\usage{
census_race_geo_table(
  geo = c("us", "state", "county", "zcta", "tract"),
  ...,
  year = 2010,
  survey = c("dec", "acs1", "acs5"),
  GEOIDs = TRUE,
  counts = TRUE
)
}
\arguments{
\item{geo}{The geographic level to return. Common options are listed in the
function signature, but any of the geographies listed at
[easycensus::cens_geo()] may be used.}

\item{...}{Further subgeographies to return, as in [easycensus::cens_geo()].}

\item{year}{The year for the data}

\item{survey}{The data product to use: either the decennial census (`"dec"`),
or the the 1-year or 5-year ACS.}

\item{GEOIDs}{If `TRUE`, return the `GEOID` column as the unique geographic
identifier; if `FALSE`, return a human-readable name. For example, with
`geo="state"`, setting `GEOIDs=FALSE` will return a column named `state`
with entries like `"Massachusetts"`.}

\item{counts}{If `TRUE`, return the table as actual population counts; if
`FALSE`, return table as percentages within each geography.}
}
\value{
A data frame with geographic identifier column(s) and six columns
  `white`, `black`, etc. containing the counts or proportion of
  residents in each racial group.
}
\description{
Downloads and prepares race-by-geography tables from U.S. census data, using
the [`easycensus`][easycensus::easycensus] package. Requires that an api key
be set up through [easycensus::cens_auth()] in that package, usually by
storing it in the `CENSUS_API_KEY` environment variable. Supports data from
the decennial census and the American Community Survey at a variety of levels
of geographic detail. The output of this function can be used directly in
[bisg()].
}
\examples{
census_race_geo_table("zcta", year=2010)
\dontrun{
# Census API key required
census_race_geo_table("us", year=2010)
census_race_geo_table("state", year=2021, survey="acs1")
census_race_geo_table("state", year=2021, survey="acs1", GEOIDs=FALSE) }
}
\concept{preproc}
