% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{disparities}
\alias{disparities}
\title{Compute Racial Disparities from Model Estimates}
\usage{
disparities(x, subgroup = FALSE, races = TRUE)
}
\arguments{
\item{x}{A `birdie` model object.}

\item{subgroup}{If `TRUE`, return subgroup-level (rather than marginal)
disparity estimates.}

\item{races}{A character vector of racial groups to compute disparities for.
The special value `TRUE`, the default, computes disparities for all racial
groups.}
}
\value{
A data frame containing a row with every possible disparity for the
  specified `races`, which are identified by columns `race_1` and `race_2`.
  The reported disparity is `estimate_1 - estimate_2`.
}
\description{
This function lets you easily compute differences in conditional expectations
between all pairs of specified racial groups.
}
\examples{
data(pseudo_vf)
r_probs = bisg(~ nm(last_name) + zip(zip), data=pseudo_vf)
fit = birdie(r_probs, turnout ~ 1, data=pseudo_vf)

disparities(fit)
disparities(fit, races=c("white", "black"))

}
\concept{estimators}
