% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_mask.R
\name{bm_mask}
\alias{bm_mask}
\title{Modify bitmaps via masking with a 'mask' bitmap}
\usage{
bm_mask(
  bm_object,
  mask = NULL,
  base = NULL,
  mode = c("luminance", "alpha"),
  hjust = "center-left",
  vjust = "center-top"
)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{mask}{A 'bm_bitmap()' object to use as a \dQuote{mask}.
Only one of \code{mask} or \code{base} may be set.}

\item{base}{A 'bm_bitmap()' object which will be \dQuote{masked} by \code{mask}.
Only one of \code{mask} or \code{base} may be set.}

\item{mode}{Either "luminance"}

\item{hjust}{One of "left", "center-left", "center-right", "right".
"center-left" and "center-right" will attempt to
place in "center" if possible but if not possible will bias
it one pixel left or right respectively.
"centre", "center", and "centre-left" are aliases for "center-left".
"centre-right" is an alias for "center-right".}

\item{vjust}{One of "bottom", "center-bottom", "center-top", "top".
"center-bottom" and "center-top" will attempt to
place in "center" if possible but if not possible will bias
it one pixel down or up respectively.
"centre", "center", and "centre-top" are aliases for "center-top".
"centre-bottom" is an alias for "center-bottom".}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
\code{bm_mask()} modifies bitmaps by using a binary bitmap \dQuote{mask}
to set certain elements to zero.
}
\details{
If necessary bitmaps will be extended by \code{bm_extend()} such that
they are the same size.
If necessary the \code{mask} will be coerced into a \dQuote{binary} mask.
If \code{mode} is "luminance" then where the \code{mask} is \code{1L}
the corresponding pixel in \code{base} will be coerced to \code{0L}.
If \code{mode} is "alpha" then where the \code{mask} is \code{0L}
the corresponding pixel in \code{base} will be coerced to \code{0L}
}
\examples{
 if (require("grid") && capabilities("png")) {
   font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
   font <- read_hex(font_file)
   one <- font[[str2ucp("1")]]
   circle_large <- as_bm_bitmap(circleGrob(r = 0.50), width = 16L, height = 16L)
   circle_small <- as_bm_bitmap(circleGrob(r = 0.40), width = 16L, height = 16L)

   circle_outline <- bm_mask(circle_large, circle_small)
   print(circle_outline, px = px_ascii)

   # U+2776 "Dingbat Negative Circled Digit One"
   circle_minus_one <- bm_mask(circle_large, one)
   print(circle_minus_one, px = px_ascii)

   # Can also do "alpha" mask
   square_full <- bm_bitmap(matrix(1L, nrow = 16L, ncol = 16L))
   square_minus_lower_left <- square_full
   square_minus_lower_left[1:8, 1:8] <- 0L
   print(square_minus_lower_left, px = px_ascii)

   circle_minus_lower_left <- bm_mask(circle_large, square_minus_lower_left, mode = "alpha")
   print(circle_minus_lower_left, px = px_ascii)
 }
}
